// utils/encrypt.js
import CryptoJS from "crypto-js";

const SECRET_KEY = "your-secret-key"; // Keep this secure in .env file for real apps

export const encryptParam = (data) => {
  const encrypted = CryptoJS.AES.encrypt(data.toString(), SECRET_KEY).toString();
  return encodeURIComponent(encrypted); // Make it URL-safe
};

export const decryptParam = (cipher) => {
  try {
    const decoded = decodeURIComponent(cipher); // Decode from URL-safe form
    const bytes = CryptoJS.AES.decrypt(decoded, SECRET_KEY);
    return bytes.toString(CryptoJS.enc.Utf8);
  } catch (err) {
    console.error("Failed to decrypt param", err);
    return null;
  }
};
