import React, { useState, useEffect } from "react";
import { Row, Col, Spin } from "antd";
import PropertylistInfo from "../../Components/PropertyInfo/PropertylistInfo";
import PropertyAdd from "../../Components/PropertyInfo/PropertyAdd";
import HeaderNavbar from "../../Components/Navbar/Header/Header";
import StickyHeader from "../../Components/PropertyInfo/StickyHeader";
import { useParams } from "react-router-dom";
import axios from "axios";
import Loading from "../../Components/Loading/Loading";
import Footer from "../../Components/Footer/Footerone";

import { URL } from "../../config";
const PropertyInfo = () => {
  const [activeSection, setActiveSection] = useState(null);
  const [showStickyHeader, setShowStickyHeader] = useState(false);
  const [property, setProperty] = useState(null);
  const [loading, setLoading] = useState(true);
  const [user, setUser] = useState(null);
  const { postpropertyId } = useParams();
  console.log(postpropertyId);
  useEffect(() => {
    setLoading(true);
    axios
      .get(`${URL}/post-property-masters/${postpropertyId}`)
      .then((res) => {
        console.log(res.data);
        setProperty(res.data);
      })
      .catch((err) => {
        console.error("Error fetching property:", err);
      })
      .finally(() => {
        setLoading(false);
      });
  }, [postpropertyId]);

  console.log(property);
  useEffect(() => {
    const sectionIds = [
      "more-details",
      "amenities",
      "neighbourhood",
      // "floor-plans",
      // "sellers",
      // "facilities",
      // "builder",
      // "faqs",
      // "articles",
    ];

    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setActiveSection(entry.target.id);
          }
        });
      },
      { rootMargin: "0px 0px -60% 0px", threshold: 0.1 }
    );

    sectionIds.forEach((sectionId) => {
      const el = document.getElementById(sectionId);
      if (el) observer.observe(el);
    });

    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const handleScroll = () => setShowStickyHeader(window.scrollY > 200);
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  useEffect(() => {
    // Simulate fetching dashboard data
    const timer = setTimeout(() => {
      setLoading(false);
    }, 1000); // change to API call if needed

    return () => clearTimeout(timer);
  }, []);

  // Fetch saved user from localStorage
  useEffect(() => {
    const storedUser = localStorage.getItem("user");
    if (storedUser) setUser(JSON.parse(storedUser));
  }, []);

  useEffect(() => {
    setLoading(true);
    axios
      .get(`${URL}/post-property-masters/${postpropertyId}`)
      .then((res) => setProperty(res.data))
      .catch((err) => console.error("Error fetching property:", err))
      .finally(() => setLoading(false));
  }, [postpropertyId]);

  // Show fullscreen loader while loading
  // if (loading) return <Spin fullscreen />;
  if (loading) return <Loading fullscreen />;

  // if (!property) return <p style={{ padding: 20 }}>Property not found.</p>;

  return (
    <div style={{ marginTop: 50, backgroundColor: "rgb(244, 245, 247)" }}>
      <HeaderNavbar user={user} setUser={setUser} />
      <StickyHeader visible={showStickyHeader} activeSection={activeSection} />
      <div style={{ padding: 24 }}>
        <Row gutter={24}>
          <Col xs={24} md={24}>
            <PropertylistInfo property={property} />
          </Col>
          {/* <Col xs={24} md={8}>
            <PropertyAdd property={property} />
          </Col> */}
        </Row>
      </div>
      <Footer />
    </div>
  );
};

export default PropertyInfo;
