import React, { useEffect, useState } from "react";
import HeroSection from "../Components/HeroSection/Herosection";
import axios from "axios";
import PropertyListings from "../Components/PropertyListing/PropertyListing";
import ServicesSection from "../Components/ServicesSections/ServicesSection";
import ExpertHelp from "../Components/ExpertHelp/ExpertHelp";
import Neighborhoods from "../Components/Neighborhoods/Neighborhoods";
import RealEstateBlogs from "../Components/RealEstate/RealEstateBlogs";
import PartnerSection from "../Components/Partner/PartnerSection";
import TestimonialSection from "../Components/Testimonials/Testimonialsection";
import PropertyLaunch from "../Components/PropertyLaunch/PropertyLaunch";
import TrySearching from "../Components/TrySearch/TrySearching";
import Footer from "../Components/Footer/Footerone";
import HeroNavBar from "../Components/Navbar/HeroNavBar";
import PhoneModal from "../Components/Modal/PhoneModal";
import OTPModal from "../Components/Modal/OtpVerificationmodal";
import Loading from "../Components/Loading/Loading";
import ExclusiveProperty from "../Components/ExclusiveProperty/ExclusiveProperty";
import RecommendedProperties from "../Components/RecommendedProperties/RecommendedProperties";
import { WhatsAppOutlined } from "@ant-design/icons";
import { FloatButton } from "antd";
import WhoWeAre from "../Components/WhatWeAre/WhoWeAre";
import OurCoreServices from "../Components/WhatWeAre/WhyWithus";
import { URL } from "../config";
import OurVision from "../Components/OurVision/OurVision";
import NeighborhoodSection from "../Components/Neighborhoods/NeighborhoodSection";
import InstagramYoutubeSection from "../Components/InstagramYoutubeSection/InstagramYoutubeSection";
import NewLaunch from "../Components/NewLaunch/NewLaunch";
import OurPromise from "../Components/OurPromise/OurPromise";
import WhyChoose from "../Components/WhyChoose/WhyChoose";
import WelcomeProperty from "../Components/WelcomeProperty/WelcomeProperty";
import WhatWeAre from "../Components/WhatWeAre/WhatWeAre";
import Gallery from "../Components/Gallery/Gallery";
import WhyBuyWithUs from "../Components/WhyBuyWithUs/WhyBuyWithUs";

const Home = () => {
  const [recommended, setRecommended] = useState([]);
  const [bestValue, setBestValue] = useState([]);
  const [newLaunch, setNewLaunch] = useState([]);
  const [loading, setLoading] = useState(true);
  const [titleSubtitle, setTitleSubtitle] = useState(null);

  const [showNav, setShowNav] = useState(false);
  const [showPhoneModal, setShowPhoneModal] = useState(false);
  const [showOtpModal, setShowOtpModal] = useState(false);
  const [user, setUser] = useState(null);

  const [mainProperty, setMainProperty] = useState(null);
  const [projectData, setProjectData] = useState([]);
  const [regData, setRegData] = useState({ contactno: "", password: "" });

  // Fetch title-subtitle
  useEffect(() => {
    const fetchTitle = async () => {
      try {
        const response = await axios.get(`${URL}/title-masters`);
        if (response.data && response.data.length > 0) {
          setTitleSubtitle(response.data[0]);
        }
      } catch (error) {
        console.log(error);
      }
    };
    fetchTitle();
  }, []);

  // Fetch properties
  useEffect(() => {
    const fetchData = async () => {
      try {
        const [recRes, bestRes, newRes] = await Promise.all([
          axios.get(`${URL}/post-property-masters/recommended`),
          axios.get(`${URL}/post-property-masters/best-value`),
          axios.get(`${URL}/post-property-masters/new-launch`),
        ]);
        setRecommended(recRes.data || []);
        setBestValue(bestRes.data || []);
        setNewLaunch(newRes.data || []);
      } catch (error) {
        console.error("Error fetching property data", error);
      } finally {
        setLoading(false);
      }
    };
    fetchData();
  }, []);

  // Format date & amount
  const formatDate = (dateString) =>
    dateString
      ? new Date(dateString).toLocaleDateString("en-US", {
          year: "numeric",
          month: "long",
          day: "numeric",
        })
      : "March 24, 2025";

  const formatAmount = (num) =>
    new Intl.NumberFormat("en-IN", { maximumFractionDigits: 0 }).format(num);

  // Fetch real estate blogs
  useEffect(() => {
    const fetchRealestate = async () => {
      try {
        const res = await axios.get(`${URL}/real-estate-masters`);
        const data = res.data;
        if (data.length > 0) {
          const first = data[0];
          setMainProperty({
            date: formatDate(first.blogDate || first.createdAt),
            title: first.blogTitle?.trim(),
            details: first.blogDescription,
            extra: "Read More",
            image: first.blogImage || fallbackMain,
          });
          setProjectData(
            data.slice(1).map((item, idx) => ({
              date: formatDate(item.blogDate || item.createdAt),
              title: item.blogTitle?.trim(),
              description: item.blogDescription,
              extra: "Read More",
              image: item.blogImage
                ? item.blogImage
                : idx === 0
                  ? fallback1
                  : idx === 1
                    ? fallback2
                    : fallback3,
              price:
                item.blogStartAmount && item.blogEndAmount
                  ? `₹ ${formatAmount(item.blogStartAmount)} - ${formatAmount(
                      item.blogEndAmount,
                    )}`
                  : item.blogStartAmount
                    ? `₹ ${formatAmount(item.blogStartAmount)}`
                    : "₹ --",
              tag: "RERA",
            })),
          );
        }
      } catch (error) {
        console.log(error);
      }
    };
    fetchRealestate();
  }, []);

  // Load user from localStorage
  useEffect(() => {
    const storedUser = localStorage.getItem("user");
    if (storedUser) setUser(JSON.parse(storedUser));
  }, []);

  // Show nav on scroll
  useEffect(() => {
    const handleScroll = () => {
      const heroHeight =
        document.querySelector(".header-main")?.offsetHeight || 500;
      setShowNav(window.scrollY > heroHeight - 100);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  // useEffect(() => {
  //   function handlePageClick(e) {
  //     const phoneModal = document.querySelector(".phone-modal");
  //     const otpModal = document.querySelector(".otp-modal");
  //     const registrationModal = document.querySelector(".registration-modal");

  //     // If user is logged in, don't open phone modal
  //     const userId = localStorage.getItem("userId");
  //     const sellerId = localStorage.getItem("sellerId");
  //     const isLoggedIn = userId || sellerId;

  //     if (isLoggedIn) return;
  //   // ✅ ignore clicks on logout
  //   if (e.target.closest(".no-login-trigger")) return;
  //     // detect autocomplete popper
  //     if (e.target.closest('.MuiAutocomplete-popper')) return;

  //     if (phoneModal && phoneModal.contains(e.target)) return;
  //     if (otpModal && otpModal.contains(e.target)) return;
  //     if (registrationModal && registrationModal.contains(e.target)) return;

  //     if (e.target.closest(".no-login-trigger")) return;

  //     if (!showPhoneModal) setShowPhoneModal(true);
  //   }

  //   document.addEventListener("click", handlePageClick);
  //   return () => document.removeEventListener("click", handlePageClick);
  // }, [showPhoneModal]);

  // Modal handlers
  const handleLoginSuccess = (userData) => {
    localStorage.setItem("user", JSON.stringify(userData));
    setUser(userData); // this updates HeaderNavbar too
    setShowOtpModal(false);
  };

  const handlePhoneSubmit = () => {
    setShowPhoneModal(false);
    setShowOtpModal(true);
  };

  const handleEditPhone = () => {
    setShowOtpModal(false);
    setShowPhoneModal(true);
  };

  if (loading) return <Loading fullscreen />;

  return (
    <>
      <HeroSection
        user={user} // pass user
        setUser={setUser}
        setShowPhoneModal={setShowPhoneModal} // pass setter
        titleSubtitle={titleSubtitle}
      />
      <WelcomeProperty />
      <OurVision />
      <OurPromise />
      <WhyBuyWithUs />
      {/* <WhyChoose /> */}
      {/* <WhatWeAre /> */}

      {/* {showNav && (
        <div style={{ position: "fixed", top: 0, width: "100%", zIndex: 1000 }}>
          <HeroNavBar
            user={user}                     // pass the user object
            onLoginClick={() => setShowPhoneModal(true)}
           />
        </div>
      )} */}

      {/* <WhoWeAre /> */}
      <RecommendedProperties properties={recommended.slice(0, 2)} />
      <PropertyListings
        properties={bestValue.slice(0, 3)}
        title=" Lello Certified Properties"
      />
      {/* <PropertyLaunch properties={newLaunch} /> */}
      <NewLaunch />
      <TrySearching />
      {/* <ExclusiveProperty /> */}
      <ExpertHelp />
      {/* <Neighborhoods /> */}
      <NeighborhoodSection />
      <RealEstateBlogs projectData={projectData} mainProperty={mainProperty} />
      <OurCoreServices />
      <PartnerSection />
      <InstagramYoutubeSection />
      <Gallery />
      <TestimonialSection />

      <Footer />

      {/* Floating Buttons */}
      <FloatButton.Group
        shape="circle"
        style={{ right: 20, bottom: 30, zIndex: 1000 }}
      >
        <FloatButton
          icon={<WhatsAppOutlined />}
          tooltip="Chat on WhatsApp"
          type="success"
          style={{
            backgroundColor: "#25D366",
            color: "#fff",
            boxShadow: "0 4px 12px rgba(0, 0, 0, 0.15)",
          }}
          onClick={() => window.open("https://wa.me/919999999999", "_blank")}
        />
        <FloatButton.BackTop
          visibilityHeight={300}
          type="primary"
          style={{
            backgroundColor: "#1677ff",
            color: "#fff",
            boxShadow: "0 4px 12px rgba(0, 0, 0, 0.15)",
          }}
        />
      </FloatButton.Group>

      {showPhoneModal && (
        <PhoneModal
          className="phone-modal"
          open={showPhoneModal}
          handleClose={(e) => {
            e.stopPropagation(); // prevent click from bubbling to document
            setShowPhoneModal(false);
          }}
          regData={regData}
          setRegData={setRegData}
          onSubmit={handlePhoneSubmit}
        />
      )}

      <OTPModal
        open={showOtpModal}
        onClose={() => setShowOtpModal(false)}
        phone={regData.contactno}
        onEditPhoneClick={handleEditPhone}
        handleOtpSuccess={handleLoginSuccess}
      />
    </>
  );
};

export default Home;
