import React, { useState, useEffect } from "react";
import { Card, Col, Row, Typography, Statistic, Spin } from "antd";
import {
  LineChartOutlined,
  UserSwitchOutlined,
  EyeOutlined,
  BarChartOutlined,
} from "@ant-design/icons";

const { Title } = Typography;

const PropertyAnalytics = () => {

    const [loading, setLoading] = useState(true);

  useEffect(() => {
    // Simulate fetching dashboard data
    const timer = setTimeout(() => {
      setLoading(false);
    }, 1000); // change to API call if needed

    return () => clearTimeout(timer);
  }, []);

  // Show fullscreen loader while loading
  if (loading) return <Spin fullscreen />;
  
  return (
    <div
      style={{
        padding: 24,
        margin: 10,
        minHeight: "88vh",
        backgroundColor: "#fff",
        borderRadius: 12,
        boxShadow: "0 4px 12px rgba(0, 0, 0, 0.05)",
      }}
    >
      <Title level={4} style={{ marginBottom: 24 }}>
        Property Analytics
      </Title>

      {/* Summary Cards Only */}
      <Row gutter={[24, 24]}>
        <Col xs={24} sm={12} md={8} lg={6}>
          <Card hoverable>
            <Statistic
              title="Total Views"
              value={2580}
              prefix={<EyeOutlined />}
            />
          </Card>
        </Col>
        <Col xs={24} sm={12} md={8} lg={6}>
          <Card hoverable>
            <Statistic
              title="Enquiries"
              value={326}
              prefix={<UserSwitchOutlined />}
            />
          </Card>
        </Col>
        <Col xs={24} sm={12} md={8} lg={6}>
          <Card hoverable>
            <Statistic
              title="Unique Visitors"
              value={1348}
              prefix={<BarChartOutlined />}
            />
          </Card>
        </Col>
        <Col xs={24} sm={12} md={8} lg={6}>
          <Card hoverable>
            <Statistic
              title="Avg. View Time"
              value="2m 34s"
              prefix={<LineChartOutlined />}
            />
          </Card>
        </Col>
      </Row>
    </div>
  );
};

export default PropertyAnalytics;
