import React, { useState, useEffect } from "react";
import {
  Table,
  Input,
  Button,
  Space,
  Card,
  Typography,
  Modal,
  message,
  Spin
} from "antd";
import {
  EyeOutlined,
  DeleteOutlined,
  SearchOutlined,
} from "@ant-design/icons";
import Loading from "../../Components/Loading/Loading";

const { Title } = Typography;

const enquiries = [
  {
    key: "1",
    name: "Akash Patil",
    contact: "9876543210",
    property: "2BHK Flat in Pune",
    message: "Is this still available?",
  },
  {
    key: "2",
    name: "Sneha Joshi",
    contact: "9123456780",
    property: "Plot in Kolhapur",
    message: "Can I schedule a visit next week?",
  },
  {
    key: "3",
    name: "Raj Deshmukh",
    contact: "9871234567",
    property: "3BHK in Satara",
    message: "Need loan assistance. Please guide.",
  },
];

const BuyerEnquiries = () => {
  const handleView = (record) => {
    Modal.info({
      title: `Message from ${record.name}`,
      content: (
        <>
          <p>
            <strong>Contact:</strong> {record.contact}
          </p>
          <p>
            <strong>Property:</strong> {record.property}
          </p>
          <p>
            <strong>Message:</strong> {record.message}
          </p>
        </>
      ),
      width: 500,
    });
  };

  const handleDelete = (record) => {
    message.success(`Deleted enquiry from ${record.name}`);
  };

  const columns = [
    {
      title: "Name",
      dataIndex: "name",
      key: "name",
    },
    {
      title: "Contact",
      dataIndex: "contact",
      key: "contact",
    },
    {
      title: "Property",
      dataIndex: "property",
      key: "property",
    },
    {
      title: "Actions",
      key: "actions",
      render: (_, record) => (
        <Space>
          <Button
            icon={<EyeOutlined />}
            onClick={() => handleView(record)}
          >
            View
          </Button>
          <Button
            icon={<DeleteOutlined />}
            danger
            onClick={() => handleDelete(record)}
          >
            Delete
          </Button>
        </Space>
      ),
    },
  ];

    const [loading, setLoading] = useState(true);

  useEffect(() => {
    // Simulate fetching dashboard data
    const timer = setTimeout(() => {
      setLoading(false);
    }, 1000); // change to API call if needed

    return () => clearTimeout(timer);
  }, []);



  return (
      <>
      {/* ✅ Show Loader first */}
      {loading && <Loading fullscreen={true} size={80} />}

      {/* ✅ After loading → Show data */}
      {!loading && (
        <div
          style={{
            padding: 24,
            margin: 10,
            minHeight: "88vh",
            backgroundColor: "#fff",
            borderRadius: 12,
            boxShadow: "0 4px 12px rgba(0, 0, 0, 0.05)",
          }}
        >
          <Space
            style={{
              display: "flex",
              justifyContent: "space-between",
              marginBottom: 20,
            }}
            wrap
          >
            <Title level={4} style={{ margin: 0 }}>
              Buyer Enquiries
            </Title>
            <Input
              placeholder="Search by name or property"
              prefix={<SearchOutlined />}
              style={{ width: 250 }}
            />
          </Space>

          <Card
            style={{ borderRadius: 10, border: "1px solid #f0f0f0" }}
            bodyStyle={{ padding: 16 }}
          >
            <Table
              columns={columns}
              dataSource={enquiries}
              pagination={{ pageSize: 5 }}
            />
          </Card>
        </div>
      )}
    </>
  );
};

export default BuyerEnquiries;

