import React, { useEffect, useState } from "react";
import { Layout, Menu, Avatar, Typography } from "antd";
import {
  DashboardSharp,
  AddBoxSharp,
  ListSharp,
  GroupAddSharp,
  QueryStatsSharp,
  PhotoLibrarySharp,
  PersonSharp,
  LogoutSharp,
} from "@mui/icons-material";
import { useNavigate } from "react-router-dom";
import axios from "axios";
import CoverPhoto from "../assets/Header/HeroIMG4.jpg";
import profilePhoto from "../assets/images/profile image 2.jpg";
import { URL } from "../config"

const { Sider } = Layout;
const { Text } = Typography;

const Sidebar = () => {
  const navigate = useNavigate();
  const [seller, setSeller] = useState({
    name: "",
    company: "",
    photo: profilePhoto,
  });

  useEffect(() => {
    const fetchSellerData = async () => {
      try {
        const sellerId = localStorage.getItem("sellerId");
        if (!sellerId) return;

        // 1. Fetch seller data
        const sellerRes = await axios.get(`${URL}/seller-masters/${sellerId}`);
        console.log(sellerRes.data)
        const sellerData = sellerRes.data;

        let userTypeName = "";
        // 2. Fetch user type name if fkuserId exists
        if (sellerData.fkuserId) {
          const userRes = await axios.get(`${URL}/usertypes/${sellerData.fkuserId}`);
          userTypeName = userRes.data.username || "";
        }

        // Set seller info into sidebar state
        setSeller({
          name: sellerData.sellerName || "Unknown",
          company: userTypeName,   // Show user type instead of raw ID
          photo: sellerData.sellerProfile
            ? `${URL}/uploads/seller-profiles/${sellerData.sellerProfile}`
            : profilePhoto,

        });
      } catch (err) {
        console.error("Failed to fetch seller data:", err);
      }
    };
    fetchSellerData();

    const handleSellerUpdate = (e) => {
      const updated = e?.detail || JSON.parse(localStorage.getItem("sellerInfo"));
      if (!updated) return;

      setSeller((prev) => ({
        name: updated.name || prev.name,
        company: updated.company || prev.company,
        photo: updated.photo
          ? `${updated.photo}?t=${Date.now()}` // ✅ force browser to fetch new image
          : prev.photo,
      }));

    };


    window.addEventListener("sellerInfoUpdated", (e) => {
      console.log("Sidebar received event:", e.detail);
      handleSellerUpdate(e);
    });


    window.addEventListener("sellerInfoUpdated", handleSellerUpdate);

    return () => window.removeEventListener("sellerInfoUpdated", handleSellerUpdate);
  }, []);



  const handleMenuClick = ({ key }) => {
    if (key === "logout") {
      localStorage.removeItem("sellerId");
          localStorage.removeItem("userId"); // ✅ clear buyer too
              localStorage.removeItem("user");

        // window.location.reload(); // refresh to re-render navbar

      navigate("/");
    } else {
      navigate(key);
    }
  };

const menuItems = [
  {
    key: "/dashboard",
    icon: <DashboardSharp />,
    label: <span style={{ fontFamily: "Poppins" }}>My Dashboard</span>,
  },
  {
    key: "/dashboard/post-new-property",
    icon: <AddBoxSharp />,
    label: <span style={{ fontFamily: "Poppins" }}>Post New Property</span>,
  },
  {
    key: "/dashboard/manage-listings",
    icon: <ListSharp />,
    label: <span style={{ fontFamily: "Poppins" }}>Publish Property</span>,
  },
  {
    key: "/dashboard/ads-management",
    icon: <PhotoLibrarySharp />,
    label: <span style={{ fontFamily: "Poppins" }}>Ads Management</span>,
  },
  {
    key: "/dashboard/profile",
    icon: <PersonSharp />,
    label: <span style={{ fontFamily: "Poppins" }}>Profile</span>,
  },
];


  return (
    <Sider
      width={260}
      theme="light"
      style={{
        display: "flex",
        flexDirection: "column",
        borderRadius: "12px",
        // overflow: "hidden",
        padding: "12px 8px",
        background: "white",
      }}
    >
      {/* Profile Card */}
      <div
        style={{
          backgroundColor: "#fff",
          borderRadius: 12,
          overflow: "hidden",
          fontFamily: "sans-serif",
          marginBottom: 10,
        }}
      >
        <div
          style={{
            height: 90,
            backgroundColor: "#cbd5e1",
            position: "relative",
          }}
        >
          <img
            src={CoverPhoto}
            alt="cover"
            style={{ width: "100%", height: "100%", objectFit: "cover", }}
          />
          <Avatar
            key={seller.photo}   // 👈 force re-render
            size={72}
            src={seller.photo}
            style={{
              backgroundColor: "#1976d2",
              position: "absolute",
              bottom: -36,
              left: "25%",
              transform: "translateX(-50%)",
              border: "3px solid white",
              
            }}
          />

        </div>
        <div
          style={{
            paddingTop: 48,
            paddingBottom: 16,
            textAlign: "Left",
            paddingInline: 12,
          }}
        >
          <Text style={{ fontWeight: 600, fontSize: 24, color: "#000",fontFamily: "Poppins" }}>
            {seller.name || "Loading..."}
          </Text>
          <br />
          <Text type="secondary" style={{ fontSize: 14, color: "#000",fontFamily: "Poppins" }}>
            {seller.company || ""}
          </Text>
        </div>
      </div>

      <div style={{ flexGrow: 1 }}>
        <Menu
          mode="inline"
          theme="light"
          defaultSelectedKeys={["/dashboard"]}
          onClick={handleMenuClick}
          items={menuItems}
          style={{ backgroundColor: "white", border: 0, }}
        />
      </div>

      <div style={{ padding: "10px 0", borderTop: "1px solid #e5e2e1" }}>
        <Menu
          mode="inline"
          theme="light"
          onClick={handleMenuClick}
          items={[{ key: "logout", icon: <LogoutSharp />, label: <span style={{ fontFamily: "Poppins" }}>Logout</span> }]}
          style={{ backgroundColor: "white", border: 0, }}
        />
      </div>
    </Sider>
  );
};

export default Sidebar;
