import React, { useEffect, useRef, useState } from "react";
import { Row, Col, Typography, Button, Rate } from "antd";
import img from "../../assets/Whychooseus/whychoose1.png";
import "./WhyChoose.css";

const { Title, Paragraph } = Typography;

const WhyChoose = () => {
  const [isVisible, setIsVisible] = useState(false);
  const containerRef = useRef(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setIsVisible(true);
          }
        });
      },
      {
        threshold: 0.2, // Trigger when 20% of the component is visible
      }
    );

    if (containerRef.current) {
      observer.observe(containerRef.current);
    }

    return () => {
      if (containerRef.current) {
        observer.unobserve(containerRef.current);
      }
    };
  }, []);

  return (
    <div className="whychoose-container" ref={containerRef}>
      <Row gutter={0} className="whychoose-row">
        {/* Left side - Image */}
        <Col xs={24} lg={12} className="whychoose-image-wrapper">
          <img
            src={img}
            alt="Why Choose Us"
            className={`whychoose-image ${isVisible ? "animate" : ""}`}
          />
          <div className={`image-badge ${isVisible ? "animate" : ""}`}>
            3BHK FLATS 4 BHK PENT HOUSE
          </div>
        </Col>

        {/* Right side - Content */}
        <Col xs={24} lg={12} className="whychoose-content">
          <Title
            level={2}
            className={`whychoose-title ${isVisible ? "animate" : ""}`}
          >
            Why Choose Lello Properties
          </Title>

          <Paragraph className="whychoose-text">
            <span className={`point ${isVisible ? "animate" : ""}`}>
              <b>
                At *Lello Properties*, we believe real estate isn't about
                transactions — it's about transformation.
              </b>{" "}
            </span>
            <br />
            <span className={`point ${isVisible ? "animate" : ""}`}>
              <b>
                {" "}
                Every property tells a story — of dreams, new beginnings, and
                lasting memories.
              </b>
            </span>
            <br />
            <span className={`point ${isVisible ? "animate" : ""}`}>
              <b>
                {" "}
                With years of expertise and a passion for connecting people to
                places, we offer a *complete real estate experience* — from
                buying and selling to renting and investing.
              </b>{" "}
            </span>
            <br />
            <span className={`point ${isVisible ? "animate" : ""}`}>
              <b>
                {" "}
                We combine *local insight, transparent processes, and modern
                technology* to make your property journey effortless, informed,
                and deeply personal.
              </b>{" "}
            </span>
          </Paragraph>

          <div className={`whychoose-footer ${isVisible ? "animate" : ""}`}>
            <Button type="primary" size="large" className="whychoose-button">
              Ready to Visit
            </Button>
            <Rate disabled defaultValue={5} className="whychoose-rating" />
          </div>
        </Col>
      </Row>
    </div>
  );
};

export default WhyChoose;
