import React from "react";
import { Box, Typography, Card, Divider } from "@mui/material";
import HomeIcon from "@mui/icons-material/Home";
import AttachMoneyIcon from "@mui/icons-material/AttachMoney";
import PublicIcon from "@mui/icons-material/Public";
import HeadsetMicIcon from "@mui/icons-material/HeadsetMic";
import SpaIcon from "@mui/icons-material/Spa";
import GavelIcon from "@mui/icons-material/Gavel";
import BuildingImage from "../../assets/WhyBuyWithUs/image.png";

const features = [
  {
    icon: <HomeIcon sx={{ fontSize: 32 }} />,
    title: "Real Estate Consulting",
    desc: "Those days are now passé when purchasing a home used to be a very arduous task...",
    color: "#F7C047",
    topColor: "#DD982A",
  },
  {
    icon: <AttachMoneyIcon sx={{ fontSize: 32 }} />,
    title: "Home Loan Consultation",
    desc: "Attractive home loans have made purchasing property very convenient...",
    color: "#EA6B43",
    topColor: "#E6491C",
  },
  {
    icon: <PublicIcon sx={{ fontSize: 32 }} />,
    title: "NRI Services",
    desc: "Investment inflows from the Indian diaspora have been rising at astounding rates...",
    color: "#63AC5D",
    topColor: "#058D40",
  },
  {
    icon: <HeadsetMicIcon sx={{ fontSize: 32 }} />,
    title: "After Sales Assistance",
    desc: "Our services do not stop once the deal is closed. We are committed...",
    color: "#8D66A1",
    topColor: "#66408A",
  },
  {
    icon: <SpaIcon sx={{ fontSize: 32 }} />,
    title: "Vastu Consultation",
    desc: "Vaastu is a subtle way of bringing harmony and channelizing energy...",
    color: "#53B6CF",
    topColor: "#0098AD",
  },
  {
    icon: <GavelIcon sx={{ fontSize: 32 }} />,
    title: "Legal Consultation",
    desc: "360 Realtors are not limited to supporting purchase/selling transactions...",
    color: "#F365A7",
    topColor: "#D61475",
  },
];

function WhyBuyWithUs() {
  return (
    <Box
      sx={{
        width: "100%",
        background: "#EAF4FF",
        py: { xs: 6, md: 10 },
        px: { xs: 2, sm: 4, md: 8 },
      }}
    >
      {/* ✅ SINGLE ROW LAYOUT using Flexbox */}
      <Box
        sx={{
          display: "flex",
          flexDirection: { xs: "column", lg: "row" },
          gap: 4,
          alignItems: "center",
          justifyContent: "center",
        }}
      >
        {/* ✅ LEFT SIDE - 6 CARDS (2 rows x 3 cards) */}
        <Box sx={{ flex: { lg: "0 0 60%" }, width: "100%" }}>
          {/* First Row - 3 Cards */}
          {/* Heading */}
          <Typography
            textAlign="center"
            fontWeight={700}
            sx={{
              fontSize: { xs: "26px", md: "38px" },
              mb: 1,
              fontFamily: "Poppins",
            }}
          >
            Why buy with Us
          </Typography>

          <Typography
            textAlign="center"
            sx={{
              mb: 6,
              fontSize: { xs: "15px", md: "18px", fontFamily: "Poppins" },
              opacity: 0.8,
            }}
          >
            Aspects that make 360 Realtors India's leading Real Estate Advisory
          </Typography>
          <Box
            sx={{
              display: "flex",
              flexDirection: { xs: "column", sm: "row" },
              gap: 2.5,
              mb: 2.5,
              justifyContent: { sm: "center", lg: "center" },
            }}
          >
            {features.slice(0, 3).map((item, i) => (
              <Card
                key={i}
                sx={{
                  position: "relative",
                  borderRadius: "16px",
                  px: 2,
                  py: 2.5,
                  height: "240px",
                  width: { xs: "100%", sm: "200px" },
                  maxWidth: { xs: "100%", sm: "200px" },
                  background: "#fff",
                  boxShadow: "0 6px 18px rgba(0,0,0,0.08)",
                  transition: "0.3s",
                  display: "flex",
                  flexDirection: "column",
                  justifyContent: "space-between",
                  "&:hover": { transform: "translateY(-4px)" },
                }}
              >
                {/* ✅ Colored Right Bar */}
                <Box
                  sx={{
                    width: "32px",
                    height: "100%",
                    position: "absolute",
                    right: 0,
                    top: 0,
                    borderRadius: "0 16px 16px 0",
                    overflow: "hidden", // ensures inner top color doesn't spill
                  }}
                >
                  {/* ✅ Full color bar */}
                  <Box
                    sx={{
                      width: "100%",
                      height: "100%",
                      background: item.color,
                    }}
                  />
                  {/* ✅ Top 20px with different color */}
                  <Box
                    sx={{
                      width: "100%",
                      height: "60px",
                      background: item.topColor,
                      position: "absolute",
                      top: 0,
                      right: 0,
                    }}
                  />
                </Box>

                {/* Card content */}
                <Box>
                  {item.icon}
                  <Typography
                    fontWeight={600}
                    mt={1}
                    fontSize="15px"
                    sx={{ mr: 1, fontFamily: "Poppins" }}
                  >
                    {item.title}
                  </Typography>
                  <Divider sx={{ my: 1 }} />
                  <Typography
                    fontSize="13px"
                    color="text.secondary"
                    sx={{ lineHeight: 1.45, mr: 2, fontFamily: "Poppins" }}
                  >
                    {item.desc}
                  </Typography>
                </Box>
              </Card>
            ))}
          </Box>

          {/* Second Row - 3 Cards */}
          <Box
            sx={{
              display: "flex",
              flexDirection: { xs: "column", sm: "row" },
              gap: 2.5,
              justifyContent: { sm: "center", lg: "center" },
            }}
          >
            {features.slice(3, 6).map((item, i) => (
              <Card
                key={i}
                sx={{
                  position: "relative",
                  borderRadius: "16px",
                  px: 2,
                  py: 2.5,
                  height: "240px",
                  width: { xs: "100%", sm: "200px" },
                  maxWidth: { xs: "100%", sm: "200px" },
                  background: "#fff",
                  boxShadow: "0 6px 18px rgba(0,0,0,0.08)",
                  transition: "0.3s",
                  display: "flex",
                  flexDirection: "column",
                  justifyContent: "space-between",
                  "&:hover": { transform: "translateY(-4px)" },
                }}
              >
                {/* ✅ Colored Right Bar */}
                <Box
                  sx={{
                    width: "32px",
                    height: "100%",
                    position: "absolute",
                    right: 0,
                    top: 0,
                    borderRadius: "0 16px 16px 0",
                    overflow: "hidden", // ensures inner top color doesn't spill
                  }}
                >
                  {/* ✅ Full color bar */}
                  <Box
                    sx={{
                      width: "100%",
                      height: "100%",
                      background: item.color,
                    }}
                  />
                  {/* ✅ Top 20px with different color */}
                  <Box
                    sx={{
                      width: "100%",
                      height: "60px",
                      background: item.topColor,
                      position: "absolute",
                      top: 0,
                      right: 0,
                    }}
                  />
                </Box>

                {/* Card content */}
                <Box>
                  {item.icon}
                  <Typography
                    fontWeight={600}
                    mt={1}
                    fontSize="15px"
                    sx={{ mr: 1, fontFamily: "Poppins" }}
                  >
                    {item.title}
                  </Typography>
                  <Divider sx={{ my: 1 }} />
                  <Typography
                    fontSize="13px"
                    color="text.secondary"
                    sx={{ lineHeight: 1.45, mr: 2, fontFamily: "Poppins" }}
                  >
                    {item.desc}
                  </Typography>
                </Box>
              </Card>
            ))}
          </Box>
        </Box>

        {/* ✅ RIGHT SIDE - BUILDING IMAGE */}
        <Box
          sx={{
            flex: { lg: "0 0 35%" },
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
          }}
        >
          <Box
            component="img"
            src={BuildingImage}
            alt="Building"
            sx={{
              width: { xs: "90%", sm: "75%", md: "70%", lg: "100%" },
              maxWidth: "520px",
              height: { xs: "auto", lg: "auto" },
              // boxShadow: "0 6px 22px rgba(0,0,0,0.2)",
              objectFit: "cover",
            }}
          />
        </Box>
      </Box>
    </Box>
  );
}

export default WhyBuyWithUs;
