import React from "react";
import { Row, Col, Typography, Card, Space, Tag } from "antd";
import {
  SafetyCertificateOutlined,
  ThunderboltOutlined,
  HomeOutlined,
} from "@ant-design/icons";
import bgImage from "../../assets/Header/HeroIMG12.jpg"
import sideImage from "../../assets/Header/HeroIMG1.jpg";

const { Title, Paragraph, Text } = Typography;

const WhoWeAre = () => {


  return (
    <div
      style={{
        position: "relative",
        padding: "110px 20px",
        // Two-layer background: soft color + image anchored to right
        background:
          `linear-gradient(135deg, #f7fbff 0%, #eef5ff 60%) , url(${bgImage})`,
        backgroundRepeat: "no-repeat, no-repeat",
        backgroundSize: "cover, 55% 100%",
        backgroundPosition: "left top, right center",
        overflow: "hidden",
      }}
    >
      {/* subtle decorative blob */}
      <div
        style={{
          position: "absolute",
          top: -120,
          left: -120,
          width: 360,
          height: 360,
          background:
            "radial-gradient(circle at 30% 30%, rgba(24,144,255,0.25), transparent 60%)",
          filter: "blur(40px)",
          pointerEvents: "none",
        }}
      />

      <Row gutter={[40, 40]} align="middle" justify="center">
        <Col xs={24} md={14} lg={18}>
          <Card
            bordered={false}
            style={{
              // glass look
              background: "rgba(255,255,255,0.8)",
              backdropFilter: "blur(8px)",
              WebkitBackdropFilter: "blur(8px)",
              borderRadius: 16,
              boxShadow: "0 10px 30px rgba(0,0,0,0.08)",
              padding: 28,
              position: "relative",
            }}
            bodyStyle={{ padding: 0 }}
          >
            {/* accent bar */}
            <Row gutter={[40, 40]} >
            <Col xs={24} md={14} lg={12}>
             <div
              style={{
                content: '""',
                position: "absolute",
                left: -6,
                top: 24,
                width: 6,
                height: 70,
                borderRadius: 6,
                background:
                  "linear-gradient(180deg, #1890ff 0%, #52c41a 100%)",
              }}
            />
            <div style={{ padding: "28px 28px 8px 28px" }}>
              <Title level={2} style={{ marginBottom: 6, color: "#001529" }}>
                Who We Are
              </Title>
              <Paragraph style={{ fontSize: 16, lineHeight: 1.9, color: "#444" }}>
                We’re a modern real estate platform that connects buyers, sellers,
                and renters with verified developers and service partners—making every
                step transparent, quick, and stress-free.
              </Paragraph>

              {/* bullet points */}
              <Space direction="vertical" size={14} style={{ display: "flex", marginTop: 8 }}>
                <Space align="start">
                  <SafetyCertificateOutlined style={{ fontSize: 20, color: "#52c41a" }} />
                  <Text style={{ fontSize: 15, color: "#555" }}>
                    Verified listings & guided assistance from trusted experts.
                  </Text>
                </Space>
                <Space align="start">
                  <ThunderboltOutlined style={{ fontSize: 20, color: "#1890ff" }} />
                  <Text style={{ fontSize: 15, color: "#555" }}>
                    Tech-enabled discovery, quick filters, and seamless experience.
                  </Text>
                </Space>
                <Space align="start">
                  <HomeOutlined style={{ fontSize: 20, color: "#faad14" }} />
                  <Text style={{ fontSize: 15, color: "#555" }}>
                    For first-time buyers to seasoned investors—tailored to you.
                  </Text>
                </Space>
              </Space>

              {/* small stats/credibility chips */}
              <Space wrap style={{ marginTop: 20 }}>
                <Tag color="blue">10k+ Listings</Tag>
                <Tag color="green">Trusted Partners</Tag>
                <Tag color="gold">Pan-India Coverage</Tag>
              </Space>
            </div>
            </Col>
            <Col xs={24} md={14} lg={12}>
             <img
      src={sideImage}
      alt="Who We Are"
      style={{
        width: "100%",
        height: "100%",
        objectFit: "cover",
        borderRadius: "12px"
      }}
    />
            </Col>
            </Row>
           
          </Card>
        </Col>

        {/* spacer col to keep composition on large screens */}
        {/* <Col xs={0} md={10} lg={12} /> */}
      </Row>
    </div>
  );
};




export default WhoWeAre;
