


import React from 'react';
import { motion } from 'framer-motion';
import SouthEastIcon from '@mui/icons-material/SouthEast';
import propertyImage from '../../assets/build.avif';
import './ServicesSection.css';

const ServicesSection = () => {
    const services = [
        {
            id: 1,
            title: "Buy a property",
            description: "Built on centuries of tradition and dedicated to innovating the luxury real estate",
            action: "Find a home",
            image: propertyImage
        },
        {
            id: 2,
            title: "Sell a property",
            description: "Built on centuries of tradition and dedicated to innovating the luxury real estate",
            action: "Find a home",
            image: propertyImage
        },
        {
            id: 3,
            title: "Rent a property",
            description: "Built on centuries of tradition and dedicated to innovating the luxury real estate",
            action: "Find a home",
            image: propertyImage
        },
        {
            id: 4,
            title: "Paying guest",
            description: "Built on centuries of tradition and dedicated to innovating the luxury real estate",
            action: "Find a home",
            image: propertyImage
        }
    ];

    const containerVariants = {
        hidden: { opacity: 0 },
        visible: {
            opacity: 1,
            transition: {
                staggerChildren: 0.1
            }
        }
    };

    const cardVariants = {
        hidden: { y: 20, opacity: 0 },
        visible: {
            y: 0,
            opacity: 1,
            transition: {
                duration: 0.5
            }
        }
    };

    return (
        <section className="services-section">
            <motion.h1
                className="section-titles"
                initial={{ opacity: 0, y: -20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5 }}
            >
                See How Realtor Properties Real Estate Industries
            </motion.h1><br />

            <motion.div
                className="services-container"
                variants={containerVariants}
                initial="hidden"
                whileInView="visible"
                viewport={{ once: true, margin: "-50px" }}
            >
                {services.map((service) => (
                    <motion.div
                        key={service.id}
                        className="service-card"
                        variants={cardVariants}
                    >
                        <div className="image-container">
                            <img src={service.image} alt={service.title} className="card-image" />
                        </div>
                        <h2>{service.title}</h2>
                        <p>{service.description}</p>
                        <button className="action-btn">
                            {service.action}
                            <SouthEastIcon className="action-icon" />
                        </button>
                    </motion.div>
                ))}
            </motion.div>
        </section>
    );
};

export default ServicesSection;
