import React from 'react';
import './SearchCategories.css';
import img1 from '../../assets/buildtwo.jpg';
import img2 from '../../assets/buildtwo.jpg';
import img3 from '../../assets/buildtwo.jpg';
import img4 from '../../assets/buildtwo.jpg';
import img5 from '../../assets/buildtwo.jpg';

const categories = [
    { img: img1, count: 50, label: 'Apartments' },
    { img: img2, count: 80, label: 'Commercial' },
    { img: img3, count: 100, label: 'Houses' },
    { img: img4, count: 60, label: 'PG/C-living' },
    { img: img5, count: 75, label: 'Plots/Lands' },
];

const SearchCategories = () => {
    return (
        <div className="search-section">
            <div className="search-header">
                <h2>Try Searching For</h2>
                <p>
                    Thousands of luxury home enthusiasts just like you have found their dream home
                </p>
            </div>

            <div className="category-cards">
                {categories.map((cat, index) => (
                    <div className="category-card" key={index}>
                        <img src={cat.img} alt={cat.label} className="category-img" />
                        <div className="category-overlay">
                            <h3>{cat.count}</h3>
                            <p>{cat.label}</p>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default SearchCategories;
