// /components/SortDropdown.jsx
import React from 'react';
import { Dropdown, Menu, Space, Button, message } from 'antd';
import {
  SortAscendingOutlined,
  ArrowDownOutlined,
  ArrowUpOutlined,
  ClockCircleOutlined,
  FilterOutlined  
} from '@ant-design/icons';

const SortDropdown = ({ onChange }) => {
  const handleMenuClick = ({ key }) => {
    if (onChange) onChange(key);
    message.success(`Sorted: ${key.replace(/([A-Z])/g, ' $1')}`);
  };

  const menu = (
    <Menu
      onClick={handleMenuClick}
      items={[
        {
          key: 'priceLow',
          label: (
            <Space>
              <ArrowDownOutlined style={{ color: '#1890ff' }} />
              Price: Low to High
            </Space>
          ),
        },
        {
          key: 'priceHigh',
          label: (
            <Space>
              <ArrowUpOutlined style={{ color: '#fa541c' }} />
              Price: High to Low
            </Space>
          ),
        },
        {
          key: 'newest',
          label: (
            <Space>
              <ClockCircleOutlined style={{ color: '#722ed1' }} />
              Newest First
            </Space>
          ),
        },
      ]}
    />
  );

  return (
   <Dropdown overlay={menu} placement="bottomRight" trigger={['click']}>
     <Button
      type="default"
      shape="default"
      icon={<FilterOutlined style={{ fontSize: 18 }} />}
      title="Sort Properties"
      style={{
        // borderRadius: '20px',
        padding: '0 16px',
        height: '36px',
        fontWeight: 500,
        display: 'flex',
        alignItems: 'center',
        gap: '8px',
        boxShadow: '0 1px 4px rgba(0,0,0,0.08)',
      }}
    >
     
    </Button>
</Dropdown>
  );
};

export default SortDropdown;
