// /components/SidebarFilters.jsx
import React, { useEffect, useState } from "react";
import {
  Card,
  Checkbox,
  Slider,
  Select,
  Typography,
  Divider,
  Tag,
  Input,
  Rate,
  Row,
  Col,
  Switch,
  Space,
  Spin,
} from "antd";
import { CheckCircleOutlined } from "@ant-design/icons";
import axios from "axios";
import { URL } from "../../config";
const { Title, Text } = Typography;
const { Option } = Select;

const SidebarFilters = ({ onFilterChange }) => {
  const [propertyType, setPropertyType] = useState([]);
  const [mainProperty, setMainProperty] = useState([]);
  const [postType, setPostType] = useState([]);
  // const [loading, setLoading] = useState(true);
  const [userType, setUseerType] = useState([]);
  // track selected filters
  const [selectedPostType, setSelectedPostType] = useState(null);
  const [selectedPropertyType, setSelectedPropertyType] = useState(null);
  const [selectedMainProperty, setSelectedMainProperty] = useState(null);
  const [selectedUserTypeId, setSelectedUseerTypeId] = useState(null)
  const [priceRange, setPriceRange] = useState([0, 100000000]);

  useEffect(() => {
    const fetchFilters = async () => {
      try {
        const [propTypeRes, mainPropRes, postTyeRes, postedbyData] = await Promise.all([
          axios.get(`${URL}/property-type-masters`),
          axios.get(`${URL}/main-propertty-type-masters`),
          axios.get(`${URL}/post-type-masters`),
          axios.get(`${URL}/usertypes`)
        ]);
        setPropertyType(propTypeRes.data || []);
        setMainProperty(mainPropRes.data || []);
        setPostType(postTyeRes.data || []);
        setUseerType(postedbyData.data)
        // console.log('propTypeRes:', propTypeRes.data)
        // console.log('mainPropRes:', mainPropRes.data);
        // console.log('postTyeRes:', postTyeRes.data)
        console.log('usertypes :', postedbyData.data)
      } catch (error) {
        console.error("Error fetching filter data:", error);
      } 
    };
    fetchFilters();
  }, []);

  // whenever filters change → send up to parent
  useEffect(() => {
    onFilterChange({
      postTypeId: selectedPostType,
      propertyTypeId: selectedPropertyType,
      mainPropertyTypeId: selectedMainProperty,
      userId: selectedUserTypeId,
      priceRange:priceRange
    });
  }, [selectedPostType, selectedPropertyType, selectedMainProperty, selectedUserTypeId, priceRange]);


  // if (loading) {
  //   return (
  //     <Spin size="large" style={{ display: "block", margin: "40px auto" }} />
  //   );
  // }

  const tagStyle = (active) => ({
    cursor: "pointer",
    backgroundColor: active ? "#1890ff" : "#f0f0f0",
    color: active ? "#fff" : "#000",
    borderColor: active ? "#1890ff" : "#d9d9d9",
  });

  return (
    <Card bordered style={{ borderRadius: 12 }}>
      {/* Hide already seen + Verified */}
      <Space direction="vertical" style={{ width: "100%" }}>
        <div>
          <Text strong>Hide already seen</Text>
          <Switch style={{ float: "right" }} />
        </div>

        <div>
          <Text strong>Verified properties</Text>
          <Switch style={{ float: "right" }} />
          <div style={{ fontSize: 12, color: "green" }}>
            <CheckCircleOutlined style={{ marginRight: 4 }} />
            by 99acres verification team
          </div>
        </div>
      </Space>

      <Divider />

      {/* Budget Slider */}
      <Title level={5}>Budget</Title>
      <Slider
        range
        min={0}
        max={100000000}
        step={100000}
        value={priceRange}
        onChange={(val) => setPriceRange(val)} // update state on change
      />

      <Row gutter={8}>
        <Col span={12}>
          <Select placeholder="Min Budget" style={{ width: "100%" }}>
            <Option value="1000000">₹10L</Option>
            <Option value="2000000">₹20L</Option>
            <Option value="5000000">₹50L</Option>
          </Select>
        </Col>
        <Col span={12}>
          <Select placeholder="Max Budget" style={{ width: "100%" }}>
            <Option value="5000000">₹50L</Option>
            <Option value="10000000">₹1Cr</Option>
          </Select>
        </Col>
      </Row>

      <Divider />

      <Title level={5}>Post Type </Title>
      <Space wrap>
        {postType.length > 0 ? (
          postType.map((type) => (
            <Tag
              key={type.postTypeId}
              bordered
              style={tagStyle(selectedPostType === type.postTypeId)}
              onClick={() =>
                setSelectedPostType((prev) =>
                  prev === type.postTypeId ? null : type.postTypeId
                )
              }
            >
              {type.posttypeName}
            </Tag>
          ))
        ) : (
          <Text type="secondary">No post types found</Text>
        )}
      </Space>

      <Divider />
      {/* Type of Property (Dynamic) */}
      <Title level={5}>Type of Property</Title>
      <Space wrap>
        {propertyType.length > 0 ? (
          propertyType.map((type) => (
            <Tag
              key={type.propertyTypeId}
              bordered
              style={tagStyle(selectedPropertyType === type.propertyTypeId)}
              onClick={() =>
                setSelectedPropertyType((prev) =>
                  prev === type.propertyTypeId ? null : type.propertyTypeId
                )

              }

            >
              {type.propertytypeName}
            </Tag>
          ))
        ) : (
          <Text type="secondary">No property types found</Text>
        )}
      </Space>

      <Divider />

      {/* Main Property (Dynamic) */}
      <Title level={5}>Main Property</Title>
      <Space wrap>
        {mainProperty.length > 0 ? (
          mainProperty.map((main) => (
            <Tag
              key={main.mainpropertytypeId}
              bordered
              style={tagStyle(selectedMainProperty === main.mainpropertytypeId)}
              onClick={() =>
                setSelectedMainProperty((prev) =>
                  prev === main.mainpropertytypeId
                    ? null
                    : main.mainpropertytypeId
                )
              }
            >
              {main.mainprpoertyName}
            </Tag>
          ))
        ) : (
          <Text type="secondary">No main property types found</Text>
        )}
      </Space>

      <Divider />

      {/* Construction Status */}
      {/* <Title level={5}>Construction Status</Title>
      <Space wrap>
        <Tag bordered>New Launch</Tag>
        <Tag bordered>Under Construction</Tag>
        <Tag bordered>Ready to move</Tag>
      </Space> */}

      <Divider />

      {/* Posted By */}
      {/* Posted By */}
      <Title level={5}>Posted by</Title>
      <Space wrap>
        {userType.length > 0 ? (
          userType
            .filter((user) => user.userId !== 1) // 👈 exclude Builder (userId 1)
            .map((user) => (
              <Tag
                key={user.userId}
                bordered
                style={tagStyle(selectedUserTypeId === user.userId)}
                onClick={() =>
                  setSelectedUseerTypeId((prev) =>
                    prev === user.userId ? null : user.userId
                  )
                }
              >
                {user.username || user.type || user.role}
              </Tag>
            ))
        ) : (
          <Text type="secondary">No user types found</Text>
        )}


      </Space>


      <Divider />

      {/* Area (sq.ft.) */}
      <Title level={5}>Area (sq.ft.)</Title>
      <Slider range min={0} max={4000} defaultValue={[500, 3000]} step={100} />
      <Row gutter={8}>
        <Col span={12}>
          <Select placeholder="Min Area" style={{ width: "100%" }}>
            <Option value="500">500 sqft</Option>
            <Option value="1000">1000 sqft</Option>
          </Select>
        </Col>
        <Col span={12}>
          <Select placeholder="Max Area" style={{ width: "100%" }}>
            <Option value="3000">3000 sqft</Option>
            <Option value="4000">4000 sqft</Option>
          </Select>
        </Col>
      </Row>

      <Divider />

      {/* Localities */}
      <Title level={5}>Localities</Title>
      <Space direction="vertical" style={{ width: "100%" }}>
        <div>
          <Checkbox>
            Tarabai Park{" "}
            <Rate
              disabled
              defaultValue={4}
              allowHalf
              style={{ fontSize: 14 }}
            />
          </Checkbox>
        </div>
        <div>
          <Checkbox>
            Nagala Park{" "}
            <Rate
              disabled
              defaultValue={3.5}
              allowHalf
              style={{ fontSize: 14 }}
            />
          </Checkbox>
        </div>
        <div>
          <Checkbox>
            Rajarampuri{" "}
            <Rate
              disabled
              defaultValue={4.5}
              allowHalf
              style={{ fontSize: 14 }}
            />
          </Checkbox>
        </div>
        <div>
          <Checkbox>
            Ichalkaranji{" "}
            <Rate
              disabled
              defaultValue={4}
              allowHalf
              style={{ fontSize: 14 }}
            />
          </Checkbox>
        </div>
        <div>
          <Checkbox>
            Ujalaiwadi{" "}
            <Rate
              disabled
              defaultValue={3.5}
              allowHalf
              style={{ fontSize: 14 }}
            />
          </Checkbox>
        </div>
        <Input placeholder="More localities..." size="small" />
      </Space>
    </Card>
  );
};

export default SidebarFilters;





// import React, { useEffect, useState } from "react";
// import { Card, Tag, Divider, Slider, Select, Typography, Space } from "antd";

// const { Title, Text } = Typography;
// const { Option } = Select;

// const SidebarFilters = ({
//   onFilterChange,
//   propertyTypes = [],
//   mainProperties = [],
//   postTypes = [],
//   users = [],
// }) => {
//   const [selectedPostType, setSelectedPostType] = useState(null);
//   const [selectedPropertyType, setSelectedPropertyType] = useState(null);
//   const [selectedMainProperty, setSelectedMainProperty] = useState(null);
//   const [selectedUserTypeId, setSelectedUserTypeId] = useState(null);
//   const [priceRange, setPriceRange] = useState([0, 100000000]);

//   useEffect(() => {
//     onFilterChange({
//       postTypeId: selectedPostType,
//       propertyTypeId: selectedPropertyType,
//       mainPropertyTypeId: selectedMainProperty,
//       userId: selectedUserTypeId,
//       priceRange: priceRange,
//     });
//   }, [selectedPostType, selectedPropertyType, selectedMainProperty, selectedUserTypeId, priceRange]);

//   const tagStyle = (active) => ({
//     cursor: "pointer",
//     backgroundColor: active ? "#1890ff" : "#f0f0f0",
//     color: active ? "#fff" : "#000",
//     borderColor: active ? "#1890ff" : "#d9d9d9",
//   });

//   return (
//     <Card bordered style={{ borderRadius: 12 }}>
//       <Divider />
//       <Title level={5}>Budget</Title>
//       <Slider
//         range
//         min={0}
//         max={100000000}
//         step={100000}
//         value={priceRange}
//         onChange={setPriceRange}
//       />

//       <Divider />
//       <Title level={5}>Post Type</Title>
//       <Space wrap>
//         {postTypes.length > 0 ? (
//           postTypes.map((type) => (
//             <Tag
//               key={type.postTypeId}
//               bordered
//               style={tagStyle(selectedPostType === type.postTypeId)}
//               onClick={() =>
//                 setSelectedPostType((prev) =>
//                   prev === type.postTypeId ? null : type.postTypeId
//                 )
//               }
//             >
//               {type.posttypeName}
//             </Tag>
//           ))
//         ) : (
//           <Text type="secondary">No post types found</Text>
//         )}
//       </Space>

//       <Divider />
//       <Title level={5}>Type of Property</Title>
//       <Space wrap>
//         {propertyTypes.length > 0 ? (
//           propertyTypes.map((type) => (
//             <Tag
//               key={type.propertyTypeId}
//               bordered
//               style={tagStyle(selectedPropertyType === type.propertyTypeId)}
//               onClick={() =>
//                 setSelectedPropertyType((prev) =>
//                   prev === type.propertyTypeId ? null : type.propertyTypeId
//                 )
//               }
//             >
//               {type.propertytypeName}
//             </Tag>
//           ))
//         ) : (
//           <Text type="secondary">No property types found</Text>
//         )}
//       </Space>

//       <Divider />
//       <Title level={5}>Main Property</Title>
//       <Space wrap>
//         {mainProperties.length > 0 ? (
//           mainProperties.map((main) => (
//             <Tag
//               key={main.mainpropertytypeId}
//               bordered
//               style={tagStyle(selectedMainProperty === main.mainpropertytypeId)}
//               onClick={() =>
//                 setSelectedMainProperty((prev) =>
//                   prev === main.mainpropertytypeId ? null : main.mainpropertytypeId
//                 )
//               }
//             >
//               {main.mainprpoertyName}
//             </Tag>
//           ))
//         ) : (
//           <Text type="secondary">No main property types found</Text>
//         )}
//       </Space>

//       <Divider />
//       <Title level={5}>Posted By</Title>
//       <Space wrap>
//         {users.length > 0 ? (
//           users
//             .filter((user) => user.userId !== 1)
//             .map((user) => (
//               <Tag
//                 key={user.userId}
//                 bordered
//                 style={tagStyle(selectedUserTypeId === user.userId)}
//                 onClick={() =>
//                   setSelectedUserTypeId((prev) =>
//                     prev === user.userId ? null : user.userId
//                   )
//                 }
//               >
//                 {user.username || user.type || user.role}
//               </Tag>
//             ))
//         ) : (
//           <Text type="secondary">No user types found</Text>
//         )}
//       </Space>
//     </Card>
//   );
// };

// export default SidebarFilters;
