import React, { useEffect, useRef, useState } from "react";
import { Tag, Button } from "antd";
import axios from "axios";
import {
  LeftOutlined,
  RightOutlined,
  CheckCircleOutlined,
  FireOutlined,
  BuildOutlined,
  HomeOutlined,
  UserOutlined,
} from "@ant-design/icons";
import "./PropertyTags.css";
import { URL } from "../../config";
// const tagData = [
//   { label: "NEW LAUNCH", icon: <FireOutlined />, color: "#ffe7ba" },
//   // { label: "Owner", icon: <UserOutlined />, color: "#e6f7ff" },
//   { label: "Verified", icon: <CheckCircleOutlined />, color: "#f6ffed" },
//   { label: "Under construction", icon: <BuildOutlined />, color: "#fff1f0" },
//   { label: "Ready To Move", icon: <HomeOutlined />, color: "#f9f0ff" },
//   { label: "Resale", icon: <UserOutlined />, color: "#e6f7ff" },
//   { label: "Loan Available", icon: <CheckCircleOutlined />, color: "#fffbe6" },
//   { label: "New Project", icon: <BuildOutlined />, color: "#e6f7ff" },
//   { label: "With Photos", icon: <HomeOutlined />, color: "#f0f5ff" },
// ];

// Map dynamic user types to custom colors
const userTypeColors = {
  owner: "#e6f7ff",     // light blue
  builder: "#fffbe6",   // light yellow
  broker: "#fff1f0",    // light red
  agents: "#f9f0ff",    // light purple
};

const PropertyTags = ({ selectedTags, setSelectedTags }) => {
  console.log(selectedTags)
  const [userTags, setUserTags] = useState([]);

  const scrollRef = useRef(null);

  const handleTagClick = (tagLabel) => {
    const updatedTags = selectedTags.includes(tagLabel)
      ? selectedTags.filter((t) => t !== tagLabel)
      : [...selectedTags, tagLabel];
    setSelectedTags(updatedTags);
  };

  const scrollLeft = () => {
    scrollRef.current.scrollBy({ left: -200, behavior: "smooth" });
  };

  const scrollRight = () => {
    scrollRef.current.scrollBy({ left: 200, behavior: "smooth" });
  };

  useEffect(() => {
    const fetchUserTypes = async () => {
      try {
        const res = await axios.get(`${URL}/usertypes`);
        console.log("API Response:", res.data);

        const allowedTypes = ["Owner", "Builder", "Broker", "Agents"];
        const filtered = res.data.filter((u) => {
          const val = u.username || u.type || u.role || "";
          return allowedTypes
            .map((t) => t.toLowerCase())
            .includes(val.toLowerCase());
        });
        console.log("Filtered:", filtered);

        const tagList = filtered.map((item) => {
          const label = item.username || item.type || item.role;
          const color =
            userTypeColors[label.toLowerCase()] || "#e6f7ff"; // fallback color
          return {
            label,
            icon: <UserOutlined />,
            color,
          };
        });
        console.log("TagList:", tagList);

        setUserTags(tagList);
      } catch (error) {
        console.error(error);
      }
    };
    fetchUserTypes();
  }, []);

  return (
    <div
      style={{
        position: "relative",
        marginBottom: 0,
        backgroundColor: "white",
        borderRadius: "30px",
      }}
    >
      <Button
        shape="circle"
        icon={<LeftOutlined />}
        onClick={scrollLeft}
        style={{
          position: "absolute",
          left: -4,
          top: "50%",
          transform: "translateY(-50%)",
          zIndex: 1,
        }}
      />

      <div
        ref={scrollRef}
        className="custom-tag-scroll"
        style={{
          overflowX: "auto",
          whiteSpace: "nowrap",
          padding: "8px 40px",
          scrollBehavior: "smooth",
        }}
      >
        {[...userTags].map((tag) => (
          <Tag
            key={tag.label}
            onClick={() => handleTagClick(tag.label)}
            style={{
              cursor: "pointer",
              display: "inline-flex",
              alignItems: "center",
              marginRight: 8,
              padding: "6px 14px",
              borderRadius: "20px",
              fontSize: "14px",
              backgroundColor: selectedTags.includes(tag.label)
                ? "#bae7ff"
                : tag.color,
              border: selectedTags.includes(tag.label)
                ? "1px solid #1890ff"
                : "none",
              color: selectedTags.includes(tag.label) ? "#096dd9" : "#000",
              transition: "all 0.3s ease",
            }}
          >
            {tag.icon}&nbsp;{tag.label}
          </Tag>
        ))}
      </div>

      <Button
        shape="circle"
        icon={<RightOutlined />}
        onClick={scrollRight}
        style={{
          position: "absolute",
          right: -4,
          top: "50%",
          transform: "translateY(-50%)",
          zIndex: 1,
        }}
      />
    </div>
  );
};

export default PropertyTags;
