// /components/Ads/AdBanner.jsx
import React from 'react';
import { Card, Typography, Button } from 'antd';
import { SoundOutlined } from '@ant-design/icons';
import pune from '../../assets/pune.jpg'

const { Title, Text } = Typography;

const AdBanner = () => {
  return (
    <Card
      hoverable
      style={{
        backgroundColor: '#fff7e6',
        border: '1px dashed #faad14',
        textAlign: 'center',
        padding: 20,
        borderRadius: 12,
        height: '400px',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        marginTop: '35%'
      }}
    >
      <div>
        <img
          src={pune}
          alt="Advertised Property"
          style={{
            width: '100%',
            height: 120,
            objectFit: 'cover',
            borderRadius: 8,
            marginBottom: 12,
          }}
        />
        <Title level={5} style={{ color: '#fa8c16', margin: 0 }}>
          📢 List Your Property with Us!
        </Title>
        <Text type="secondary" style={{ fontSize: 13 }}>
          Reach 10,000+ buyers monthly. Perfect for owners and builders!
        </Text>
      </div>

      <Button
        type="primary"
        size="small"
        style={{ marginTop: 16, alignSelf: 'center' }}
      >
        Post Ad
      </Button>
    </Card>
  );
};

export default AdBanner;
