import React from 'react';
import { motion } from 'framer-motion';
import './PropertyLaunch.css';
import propertyImage from '../../assets/PostIMG/PostImg_9.jpg';
import { useNavigate } from 'react-router-dom';
import img1 from "../../assets/PostIMG/PostImg_5.jpeg";
import img2 from "../../assets/PostIMG/PostImg_6.png";
import img3 from "../../assets/PostIMG/PostImg_7.jpeg";

const fallbackImages = [img1, img2, img3];

const PropertyLaunch = ({ properties = [] }) => {
  const featuredProperty = properties[0];
  const remainingProperties = properties.slice(1, 4); // Only next 3
  const navigate = useNavigate();

  const handleCardClick = (propertyId) => {
    localStorage.setItem('id', propertyId);
    navigate(`/Propertyinfo/${propertyId}`);
  };

  return (
    <div className="pl-section">
      <div className="pl-wrapper">

        {/* Header */}
        <div className="pl-header">
          <motion.div
            className="pl-header-left"
            initial={{ x: -100, opacity: 0 }}
            whileInView={{ x: 0, opacity: 1 }}
            transition={{ duration: 0.6 }}
            viewport={{ once: true }}
          >
            <h2>New Launch</h2>
            <p>Discover unbeatable deals and exceptional value on your next property investment.</p>
          </motion.div>

          <motion.button
            className="pl-view-more-btn"
            initial={{ x: 100, opacity: 0 }}
            whileInView={{ x: 0, opacity: 1 }}
            transition={{ duration: 0.6 }}
            viewport={{ once: true }}
          >
            View more
          </motion.button>
        </div>

        {/* Hero Image */}
        <motion.div
          className="pl-hero-image"
          initial={{ scale: 0.95, opacity: 0 }}
          whileInView={{ scale: 1, opacity: 1 }}
          transition={{ duration: 0.8 }}
          viewport={{ once: true }}
        >
          <img src={propertyImage} alt="Property Banner" />
        </motion.div>

        {/* Featured Property */}
        {featuredProperty && (
          <motion.div
            className="pl-featured-card"
            initial={{ y: 50, opacity: 0 }}
            whileInView={{ y: 0, opacity: 1 }}
            transition={{ duration: 0.8 }}
            viewport={{ once: false, amount: 0.5 }}
          >
            <div className="pl-featured-left">
              <h3>{featuredProperty.Property_Title || "Featured Property"}</h3>
              <p>{featuredProperty.apartmentNameAreaName || "Location not available"}</p>
            </div>
            <div className="pl-featured-right">
              <p className="pl-price-text">
                Starting from <br />
                <span>₹ {featuredProperty.price?.toLocaleString() || "N/A"}</span>
              </p>
            </div>
          </motion.div>
        )}

        {/* Property Cards for next 3 */}
        <div className="pl-card-row">
          {remainingProperties.map((property, index) => {
            // ✅ Safe and consistent image fallback logic
            const imageSrc =
              property.photo && property.photo.trim() !== ""
                ? property.photo
                : fallbackImages[index % fallbackImages.length];

            return (
              <motion.div
                key={property.postpropertyId || index}
                className="pl-card-box"
                initial={{ y: 100, opacity: 0 }}
                whileInView={{ y: 0, opacity: 1 }}
                transition={{ duration: 0.6, delay: index * 0.2 }}
                viewport={{ once: false, amount: 0.2 }}
                onClick={() => handleCardClick(property.postpropertyId)}
                style={{ cursor: "pointer" }}
              >
                <img
                  src={imageSrc}
                  alt={property.Property_Title || "Property"}
                  onError={(e) => {
                    // ✅ Handle broken backend image URLs gracefully
                    e.target.onerror = null;
                    e.target.src = fallbackImages[index % fallbackImages.length];
                  }}
                />
                <div className="pl-card-info">
                  <h4>{property.Property_Title || "New Property"}</h4>
                  <p>{property.subtitle || property.apartmentNameAreaName || "Prime Location"}</p>
                  <p className="pl-price-text">
                    Starting from <br />
                    <span>₹ {property.price?.toLocaleString() || "N/A"}</span>
                  </p>
                </div>
              </motion.div>
            );
          })}
        </div>
      </div>
    </div>
  );
};

export default PropertyLaunch;
