import React from "react";
import { Button } from "antd";
import { DownloadOutlined } from "@ant-design/icons";

const StickyHeader = ({ visible, activeSection }) => {
  if (!visible) return null;

  const navItems = [
    "More Details",
    "Amenities",
    "Neighbourhood"
    // "Floor Plans",
    // "Sellers",
    // "Facilities",

    // "Builder",
    // "FAQs",
    // "Articles",
  ];

  return (
    <div style={styles.headerContainer}>
      {/* Navigation Links */}
      <div style={styles.navLinks}>
        {navItems.map((item) => {
          const sectionId = item.toLowerCase().replace(/\s/g, "-");
          const isActive = activeSection === sectionId;

          return (
            <span
              key={item}
              style={{
                textDecoration: "none",
                cursor: "pointer",
                color: isActive ? "#0057ff" : "#001529",
                borderBottom: isActive ? "2px solid #0057ff" : "none",
                paddingBottom: 4,
                fontWeight: isActive ? 600 : 400,
                transition: "color 0.3s ease",
              }}
              onClick={() => {
                const section = document.getElementById(sectionId);
                if (section) {
                  section.scrollIntoView({ behavior: "smooth" });
                }
              }}
            >
              {item}
            </span>
          );
        })}
      </div>

      {/* Action Buttons */}
      <div style={styles.actions}>
        <Button icon={<DownloadOutlined />} style={styles.brochureBtn}>
          Brochure
        </Button>
        <Button type="primary" style={styles.viewNumberBtn}>
          View Number
        </Button>
      </div>
    </div>
  );
};

const styles = {
  headerContainer: {
    position: "fixed",
    top: 68,
    zIndex: 999,
    width: "100vw",
    backgroundColor: "#fff",
    padding: "10px 24px",
    boxShadow: "0 2px 8px rgba(0,0,0,0.05)",
    display: "flex",
    justifyContent: "space-between",
    alignItems: "center",
    borderBottom: "1px solid #eaeaea",
  },
  navLinks: {
    display: "flex",
    gap: "24px",
    fontSize: "16px",
    fontWeight: 500,
  },
  link: {
    cursor: "pointer",
    fontWeight: 500,
    padding: "4px 0",
    transition: "color 0.3s, border-bottom 0.3s",
  },
  actions: {
    display: "flex",
    gap: "12px",
  },
  brochureBtn: {
    color: "#0057ff",
    borderColor: "#0057ff",
    backgroundColor: "#fff",
  },
  viewNumberBtn: {
    backgroundColor: "#0057ff",
    borderColor: "#0057ff",
  },
};

export default StickyHeader;
