import React, { useRef, useState, useEffect } from 'react';
import { Card, Row, Col, Typography, Button, Space } from 'antd';
import {
  DownloadOutlined,
  ArrowRightOutlined,
  ArrowLeftOutlined,
  HomeOutlined,
} from '@ant-design/icons';

const { Title, Text } = Typography;

const apartmentData = [
  {
    type: '2 BHK',
    carpetArea: '811 - 828 sq.ft.',
    areaInSqm: '(75.34 - 76.92 sq.m.)',
  },
  {
    type: '3 BHK',
    carpetArea: '1014 - 1021 sq.ft.',
    areaInSqm: '(94.2 - 94.85 sq.m.)',
  },
  {
    type: '4 BHK',
    carpetArea: '1626 - 1919 sq.ft.',
    areaInSqm: '(151.06 - 178.28 sq.m.)',
  },
  {
    type: '5 BHK',
    carpetArea: '2000 - 2200 sq.ft.',
    areaInSqm: '(185.8 - 204.4 sq.m.)',
  },
];

const PriceSection = () => {
  const scrollRef = useRef(null);
  const [showBackArrow, setShowBackArrow] = useState(false);

  const handleScroll = () => {
    if (scrollRef.current) {
      const scrollLeft = scrollRef.current.scrollLeft;
      setShowBackArrow(scrollLeft > 0);
    }
  };

  useEffect(() => {
    const container = scrollRef.current;
    if (container) {
      container.addEventListener('scroll', handleScroll);
    }
    return () => {
      if (container) {
        container.removeEventListener('scroll', handleScroll);
      }
    };
  }, []);

  const scrollLeft = () => {
    if (scrollRef.current) {
      scrollRef.current.scrollBy({ left: -300, behavior: 'smooth' });
    }
  };

  const scrollRight = () => {
    if (scrollRef.current) {
      scrollRef.current.scrollBy({ left: 300, behavior: 'smooth' });
    }
  };

  return (
    <div style={{ padding: '2rem', position: 'relative', background: '#fff' }}>
      {/* Header */}
      <Row justify="space-between" align="middle" style={{ marginBottom: 24 }}>
        <Col>
          <Space align="start">
            <HomeOutlined style={{ fontSize: '24px', color: '#faad14' }} />
            <div>
              <Title level={4} style={{ margin: 0 }}>
                Price on Request
              </Title>
              <Text type="secondary" style={{ fontSize: 12 }}>
                PRICE RANGE
              </Text>
              <br />
              <Text strong>2, 3, 4, 5 BHK Apartment</Text>
            </div>
          </Space>
        </Col>
        <Col>
          <Button icon={<DownloadOutlined />} type="primary">
            Download Brochure
          </Button>
        </Col>
      </Row>

      {/* Scrollable cards */}
      <div
        ref={scrollRef}
        style={{
          display: 'flex',
          overflowX: 'auto',
          scrollBehavior: 'smooth',
          gap: '1rem',
          scrollbarWidth:'none'
        }}
      >
        {apartmentData.map((item, index) => (
          <Card
            key={index}
            bordered
            style={{
              minWidth: 280,
              flex: '0 0 auto',
              borderRadius: '8px',
             }}
          >
            <Text strong style={{ fontSize: 16, color: '#1d3557' }}>
              {item.type}
            </Text>{' '}
            <Text type="secondary">Apartment</Text>
            <div style={{ marginTop: 8 }}>
              <Text type="secondary">Carpet Area</Text>
              <br />
              <Text strong>{item.carpetArea}</Text>{' '}
              <Text type="secondary">{item.areaInSqm}</Text>
            </div>
            <div style={{ marginTop: 16 }}>
              <Text strong style={{ fontSize: 16 }}>
                Price on Request
              </Text>
            </div>
          </Card>
        ))}
      </div>

      {/* Conditional Back Arrow */}
      {showBackArrow && (
        <Button
          type="primary"
          shape="circle"
          icon={<ArrowLeftOutlined />}
          size="large"
          onClick={scrollLeft}
          style={{
            position: 'absolute',
            left: 24,
            bottom: 24,
            boxShadow: '0 2px 8px rgba(0,0,0,0.2)',
          }}
        />
      )}

      {/* Always Show Forward Arrow */}
      <Button
        type="primary"
        shape="circle"
        icon={<ArrowRightOutlined />}
        size="large"
        onClick={scrollRight}
        style={{
          position: 'absolute',
          right: 24,
          bottom: 24,
          boxShadow: '0 2px 8px rgba(0,0,0,0.2)',
        }}
      />
    </div>
  );
};

export default PriceSection;
