import React from 'react';
import { Row, Col, Card, Typography, Tag, Button, Space } from 'antd';
import articleimg1 from '../../assets/images/articalimg1.png';
import articalimg2 from '../../assets/images/articalimg2.png'
const { Title, Text } = Typography;

const articles = [
  {
    title: 'Top 5 emerging areas to invest in Kolhapur',
    date: 'Jun 26, 2024',
    image: articleimg1,
  },
  {
    title: 'Mahabhulekh: How to download 7/12 online?',
    date: 'Jul 17, 2023',
    image: articalimg2,
  },
];

const quickLinks = [
  'Bedekar Dhanashree Svasti Floor Plans',
  'Bedekar Dhanashree Svasti Photos',
  'Bedekar Dhanashree Svasti Amenities',
];


function ArticalSection(){

    return(
        <>
         <div style={{ padding: '2rem' }}>
      {/* Interesting Reads */}
      <Title level={3}>Interesting Reads</Title>
      <Row gutter={[24, 24]}>
        {articles.map((article, index) => (
          <Col xs={24} sm={12} md={8} key={index}>
            <Card
              hoverable
              cover={<img alt={article.title} src={article.image} style={{ borderRadius: '8px 8px 0 0' }} />}
              style={{ borderRadius: 8 }}
              bodyStyle={{ padding: 12 }}
            >
              <Title level={5} style={{ margin: 0 }}>
                {article.title}
              </Title>
              <Text type="secondary">{article.date}</Text>
            </Card>
          </Col>
        ))}
      </Row>

      {/* Quick Links */}
      <div style={{ marginTop: '3rem' }}>
        <Title level={4}>Bedekar Dhanashree Svasti - Quick Links</Title>
        <Space wrap size={[12, 12]}>
          {quickLinks.map((link, index) => (
            <Button key={index} style={{ borderRadius: 999 }} type="default">
              {link}
            </Button>
          ))}
        </Space>
      </div>
    </div>
        </>
    )
}
export default ArticalSection