import React from "react";
import { Card, Typography, Tag } from "antd";
import {
  CheckCircleOutlined,
  CloseCircleOutlined,
  StarOutlined,
} from "@ant-design/icons";

const { Title, Text } = Typography;

const PackageCard = ({ name, price, features, status, buttonText, color }) => {
  const statusTag = {
    active: <Tag color="green">Active</Tag>,
    expired: <Tag color="red">Expired</Tag>,
    notSubscribed: <Tag color="orange">Not Subscribed</Tag>,
  };

  return (
    <Card
      hoverable
      style={{
        borderRadius: "12px",
        boxShadow: "0 4px 12px rgba(0, 0, 0, 0.05)",
        transition: "all 0.3s ease",
        minHeight: 320,
      }}
    >
      <div style={{ textAlign: "center", marginBottom: 16 }}>
        <StarOutlined
          style={{
            fontSize: 32,
            color: color || "#1890ff",
            marginBottom: 8,
          }}
        />
        <Title level={4} style={{ marginBottom: 0 }}>
          {name}
        </Title>
        <Text type="secondary">{price}</Text>
      </div>

      <ul style={{ paddingLeft: 20, marginBottom: 16 }}>
        {features.map((feature, index) => (
          <li key={index} style={{ marginBottom: 8 }}>
            <CheckCircleOutlined style={{ color: "#52c41a", marginRight: 8 }} />
            {feature}
          </li>
        ))}
      </ul>

      <div style={{ marginTop: 8 }}>{statusTag[status]}</div>

      <button
        style={{
          marginTop: 12,
          padding: "8px 20px",
          width: "100%",
          backgroundColor: color || "#1890ff",
          color: "#fff",
          border: "none",
          borderRadius: 6,
          fontWeight: 600,
          cursor: "pointer",
        }}
      >
        {buttonText}
      </button>
    </Card>
  );
};

export default PackageCard;
