import React from "react";
import { motion } from "framer-motion";
import visionbuilding from "../../assets/OurVision/ourvisionbg.png";
import stars from "../../assets/OurVision/stars.png";
import bgimg from "../../assets/OurVision/Screenshotourvision.png";

const OurVision = () => {
  return (
    <div>
      <div className="vision-container">
        {/* Left Text Section */}
        <div className="vision-text" >
          <h2>
            Our <span>Vision</span>
          </h2>
          <p
            style={{
              fontSize: "clamp(16px, 2vw, 20px)",
              fontFamily: "Poppins",
            }}
          >
            To be the most trusted and people-first real estate brand <br />
            <b>
              helping you discover homes and investments that inspire confidence
              and joy.
            </b>
          </p>
          {/* <h4>Vision Points:</h4> */}
          <ul
            style={{
              fontSize: "clamp(14px, 2vw, 20px)",
              fontFamily: "Poppins",
              marginTop: 50,
            }}
          >
            <li>
              To bring honesty, innovation, and modern solutions to every real
              estate experience.
            </li>
            <li>
              To help clients find <b>verified, value-driven </b> properties
              that truly fit their goals.
            </li>
            <li>
              To build <b>lasting relationships</b> founded on trust and
              results.
            </li>
            <li>
              To lead with <b>professionalism, empathy, and excellence </b> in
              every interaction.
            </li>
          </ul>
        </div>

        {/* Right Image Section with animation */}
        <div className="vision-image">
          <img src={stars} alt="Stars" className="stars-img" />

          <motion.div
            className="vision-img-wrapper"
            initial={{ y: 100, opacity: 0 }} // 👈 Start below and invisible
            whileInView={{ y: 0, opacity: 1 }} // 👈 Slide up into place
            transition={{ duration: 1, ease: "easeOut" }}
            viewport={{ once: true, amount: 0.5 }} // 👈 triggers when 50% visible
          >
            <img src={visionbuilding} alt="Our Vision" />
          </motion.div>
        </div>
      </div>

      <style jsx>{`
        .vision-container {
          display: flex;
          flex-wrap: wrap;
          justify-content: space-between;
          align-items: center;
          padding: clamp(20px, 4vw, 40px);
          gap: 30px;
          background-image: url(${bgimg});
          background-size: 120% auto;
          background-repeat: no-repeat;
          background-position: right -100px center;
          transition: all 0.3s ease;
        }

        .vision-text {
          flex: 1 1 400px;
          min-width: 280px;
        }

        .vision-text h2 {
          font-size: clamp(24px, 5vw, 32px);
          font-weight: bold;
          margin-bottom: 15px;
        }

        .vision-text h2 span {
          color: #1e73be;
        }

        .vision-text p {
          font-size: clamp(14px, 2.5vw, 18px);
          line-height: 1.6;
          margin-bottom: 20px;
        }

        .vision-text h4 {
          font-size: clamp(16px, 2.5vw, 20px);
          color: #1e73be;
          margin-bottom: 10px;
        }

        .vision-text ul {
          font-size: clamp(13px, 2vw, 16px);
          line-height: 1.8;
          padding-left: 20px;
        }

        .vision-image {
          flex: 0 1 auto;
          width: 100%;
          max-width: 500px;
          display: flex;
          justify-content: center;
          align-items: center;
          position: relative;
        }

        .stars-img {
          position: absolute;
          left: 0;
          top: 20px;
          z-index: 1;
          width: clamp(40px, 8vw, 80px);
          height: auto;
        }

        .vision-img-wrapper {
          width: clamp(250px, 50vw, 400px);
          height: clamp(250px, 50vw, 400px);
          overflow: hidden;
          border-top-left-radius: 60%;
          border-bottom-right-radius: 50px;
          margin-left: auto;
          margin-right: clamp(0px, 5vw, 80px);
        }

        .vision-img-wrapper img {
          width: 100%;
          height: 100%;
          object-fit: cover;
          object-position: center top;
        }

        @media (max-width: 1024px) {
          .vision-container {
            background-position: right center;
          }
        }

        @media (max-width: 768px) {
          .vision-container {
            background-size: cover;
            background-position: center;
          }
        }

        @media (max-width: 480px) {
          .vision-container {
            background-size: 150% auto;
            background-position: center;
          }

          .vision-text ul {
            padding-left: 15px;
          }

          .vision-img-wrapper {
            width: 70vw;
            height: 70vw;
            margin-right: 0;
          }

          .stars-img {
            width: 50px;
          }
        }
      `}</style>
    </div>
  );
};

export default OurVision;
