import React, { useEffect, useRef, useState } from "react";
import { Row, Col, Typography, Button, Rate } from "antd";
import img from "../../assets/Whychooseus/whychoose1.png";
import "./Ourpromise.css";

const { Title, Paragraph } = Typography;

const OurPromiss = () => {
  const [isVisible, setIsVisible] = useState(false);
  const containerRef = useRef(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setIsVisible(true);
          }
        });
      },
      {
        threshold: 0.2, // Trigger when 20% of the component is visible
      }
    );

    if (containerRef.current) {
      observer.observe(containerRef.current);
    }

    return () => {
      if (containerRef.current) {
        observer.unobserve(containerRef.current);
      }
    };
  }, []);

  return (
    <div className="ourpromise-container" ref={containerRef}>
      <Row gutter={0} className="whychoose-row">
        {/* Left side - Image */}
        <Col xs={24} lg={12} className="whychoose-image-wrapper">
          <img
            src={img}
            alt="Why Choose Us"
            className={`whychoose-image ${isVisible ? "animate" : ""}`}
          />
          {/* <div className={`image-badge ${isVisible ? 'animate' : ''}`}>
            3BHK FLATS 4 BHK PENT HOUSE
          </div> */}
        </Col>

        {/* Right side - Content */}
        <Col xs={24} lg={12} className="whychoose-content">
          <Title
            level={1}
            className={`whychoose-title ${isVisible ? "animate" : ""}`}
            style={{ fontFamily: "Poppins" }}
          >
            Our Promise
          </Title>
          <Paragraph className="">
            <span style={{ fontFamily: "Poppins", fontSize: "22px" }}>
              {" "}
              We are not just selling properties
            </span>{" "}
            <br />
            <span
              style={{
                fontWeight: 700,
                fontFamily: "Poppins",
                fontSize: "22px",
              }}
            >
              we're helping you find the place where life truly begins.
            </span>
          </Paragraph>

          <Paragraph>
            <span style={{ fontSize: "22px", fontFamily: "Poppins" }}>
              At{" "}
              <span style={{ fontWeight: 700, color: "#ff5937",fontFamily: "Poppins", }}>
                Lello Properties
              </span>
              , trust is the foundation we build on. Every home, every deal,
              every relationship shaped with care, integrity, and purpose.
            </span>
          </Paragraph>

          {/* <div className={`whychoose-footer ${isVisible ? 'animate' : ''}`}>
            <Button type="primary" size="large" className="whychoose-button">
              Ready to Visit
            </Button>
            <Rate disabled defaultValue={5} className="whychoose-rating" />
          </div> */}
        </Col>
      </Row>
    </div>
  );
};

export default OurPromiss;
