import React from 'react';
import './Neighborhoods.css';

import kolhapur from '../../assets/PostIMG/PostImg_25.png';
import sangli from '../../assets/PostIMG/PostImg_19.jpg';
import pune from '../../assets/PostIMG/PostImg_24.jpg';
import belgaum from '../../assets/PostIMG/PostImg_20.jpg';
import satara from '../../assets/PostIMG/PostImg_21.jpg';

const cityData = [
  { name: 'Kolhapur', properties: 30, image: kolhapur },
  { name: 'Sangli', properties: 30, image: sangli },
  { name: 'Pune', properties: 32, image: pune },
  { name: 'Belgaum', properties: 12, image: belgaum },
  { name: 'Satara', properties: 10, image: satara },
];

const Neighborhoods = () => {
  return (
    <section className="neigh-section">
      <div className="neigh-header">
        <h2>Explore the neighborhoods</h2>
        <p>Find your dream apartment with our listing</p>
      </div>

      <div className="neigh-layout">
        <div className="neigh-left-grid">
          {cityData.slice(0, 4).map((city, index) => (
            <article key={index} className="neigh-card">
              <img
                src={city.image}
                alt={city.name}
                className="neigh-img"
                loading="lazy"
              />
              <span className="neigh-badge">{city.properties} Properties</span>
              <div className="neigh-overlay">
                <h3 className="neigh-name">{city.name}</h3>
              </div>
            </article>
          ))}
        </div>

        <article className="neigh-right-card">
          <img
            src={cityData[4].image}
            alt={cityData[4].name}
            className="neigh-img"
            loading="lazy"
          />
          <span className="neigh-badge">{cityData[4].properties} Properties</span>
          <div className="neigh-overlay">
            <h3 className="neigh-name">{cityData[4].name}</h3>
          </div>
        </article>
      </div>
    </section>
  );
};

export default Neighborhoods;
