import React from "react";
import { Box, Typography, Container } from "@mui/material";
import BgImg from "../../assets/neighborhoods/Frame10737.png"
import KolhapurImg from "../../assets/PostIMG/PostImg_18.jfif"
import PuneImg from "../../assets/PostIMG/PostImg_24.jpg"
import SataraImg from "../../assets/PostIMG/PostImg_21.jpg"
import SangliImg from "../../assets/PostIMG/PostImg_19.jpg"
import BelgaumIMg from "../../assets/PostIMG/PostImg_20.jpg"

const neighborhoods = [
  {
    name: "Belgaum",
    image: BelgaumIMg,
    color: "#2196F3",
    size: { xs: 160, sm: 180, md: 200 }, // 👈 Individual size
  },
  {
    name: "Sangli",
    image: SangliImg,
    color: "#FF7043",
    size: { xs: 190, sm: 210, md: 250 },
  },
  {
    name: "Satara",
    image: SataraImg,
    color: "#66BB6A",
    size: { xs: 180, sm: 200, md: 220 },
  },
  {
    name: "Kolhapur",
    image: KolhapurImg,
    color: "#26C6DA",
    size: { xs: 200, sm: 220, md: 280 },
  },
  {
    name: "Pune",
    image: PuneImg,
    color: "#7CB342",
    size: { xs: 220, sm: 250, md: 300 },
  },
];

const NeighborhoodCard = ({ name, image, color, index, size }) => {
  const positions = [
    { top: "22%", left: "2%", zIndex: 5 },
    { top: "15%", right: "43%", zIndex: 3 },
    { top: "42%", left: "15%", zIndex: 4 },
    { top: "38%", left: "46%", zIndex: 2  },
    { top: "5%", right: "2%", zIndex: 1  },
  ];

  

  return (
    <Box
      sx={{
        position: { xs: "relative", md: "absolute" },
        ...positions[index],
        width: { xs: `${size.xs}px`, sm: `${size.sm}px`, md: `${size.md}px` },
        height: { xs: `${size.xs}px`, sm: `${size.sm}px`, md: `${size.md}px` },
        margin: { xs: "20px auto", md: "0" },
        cursor: "pointer",
        transition: "transform 0.3s ease",
        "&:hover": {
          transform: "scale(1.05)",
          zIndex: 10,
        },
      }}
    >
      {/* Outer Border */}
      <Box
        sx={{
          width: "100%",
          height: "100%",
          clipPath:
            "polygon(30% 0%, 70% 0%, 100% 30%, 100% 70%, 70% 100%, 30% 100%, 0% 70%, 0% 30%)",
          backgroundColor: color,
          display: "flex",
          alignItems: "center",
          justifyContent: "center",
          p: "6px",
        }}
      >
        {/* Inner Image */}
        <Box
          sx={{
            width: "100%",
            height: "100%",
            clipPath:
              "polygon(30% 0%, 70% 0%, 100% 30%, 100% 70%, 70% 100%, 30% 100%, 0% 70%, 0% 30%)",
            backgroundImage: `url(${image})`,
            backgroundSize: "cover",
            backgroundPosition: "center",
            position: "relative",
            "&::before": {
              content: '""',
              position: "absolute",
              top: 0,
              left: 0,
              right: 0,
              bottom: 0,
              background:
                "linear-gradient(to bottom, rgba(0,0,0,0.1), rgba(0,0,0,0.4))",
              zIndex: 1,
            },
          }}
        >
          <Typography
            variant="h5"
            sx={{
              position: "absolute",
              top: "50%",
              left: "50%",
              transform: "translate(-50%, -50%)",
              color: "white",
              fontWeight: "bold",
              zIndex: 2,
              textShadow: "2px 2px 8px rgba(0,0,0,0.7)",
              textAlign: "center",
              px: 1,
              fontFamily: "Poppins",
            }}
          >
            {name}
          </Typography>
        </Box>
      </Box>
    </Box>
  );
};

export default function NeighborhoodSection() {
  return (
    <Box
      sx={{
        minHeight: "100vh",
        background: "linear-gradient(135deg, #e0e0e0 0%, #f5f5f5 100%)",
        py: { xs: 4, md: 6 },
        position: "relative",
        overflow: "hidden",
        "&::before": {
          content: '""',
          position: "absolute",
          top: 30,
          left: 0,
          width: "800px",
          height: "700px",
        backgroundImage: `url(${BgImg})`,
          backgroundSize: "cover",
          opacity: 0.65,
          filter: "grayscale(100%)",
        },
      }}
    >
      <Container maxWidth="xl">
        <Typography
          variant="h3"
          align="center"
          sx={{
            mb: { xs: 4, md: 2 },
            fontWeight: "bold",
            color: "#333",
            fontSize: { xs: "1.5rem", sm: "2rem", md: "2.5rem" },
            fontFamily: "Poppins",
          }}
        >
          Find Your Dream Property With our listing
        </Typography>

        <Box
          sx={{
            display: "flex",
            flexDirection: { xs: "column", md: "row" },
            alignItems: { xs: "flex-start", md: "center" },
            gap: { xs: 2, md: 0 },
          }}
        >
          <Box sx={{ flex: { xs: "1", md: "0 0 35%" }, mb: { xs: 4, md: 0 } }}>
            <Typography
              variant="h2"
              sx={{
                fontSize: { xs: "2.5rem", sm: "3.5rem", md: "4.5rem" },
                fontWeight: "bold",
                lineHeight: 1.2,
                fontFamily: "Poppins",
              }}
            >
              Explore{" "}
              <span style={{ color: "#e91e63" }}>the neighborhoods..</span>
            </Typography>
          </Box>

          <Box
            sx={{
              flex: 1,
              position: "relative",
              minHeight: { xs: "auto", md: "600px" },
              display: { xs: "flex", md: "block" },
              flexDirection: { xs: "column", md: "row" },
              alignItems: { xs: "center", md: "flex-start" },
            }}
          >
            {neighborhoods.map((neighborhood, index) => (
              <NeighborhoodCard
                key={neighborhood.name}
                {...neighborhood}
                index={index}
              />
            ))}
          </Box>
        </Box>
      </Container>
    </Box>
  );
}
