import React, { useState } from "react";
import {
  FiSearch,
  FiSettings,
  FiMic,
  FiFilter
} from "react-icons/fi";
import { Button } from "antd";
import SearchIcon from "@mui/icons-material/Search";
import SaveIcon from "@mui/icons-material/Save";
import ClearIcon from "@mui/icons-material/Clear";
import CheckBoxSharpIcon from "@mui/icons-material/CheckBoxSharp";
import { useNavigate } from "react-router-dom";

const SearchBar = () => {
  const [showFilters, setShowFilters] = useState(false);
  const [activeTab, setActiveTab] = useState("Buy");
  const [searchCity, setSearchCity] = useState("");

  const navigate = useNavigate();

  const tabs = [
    "Buy",
    "Rent",
    "New Launch",
    "Commercial",
    "Plot/Lands",
    "Projects",
  ];
  const filters = ["Budget", "City", "Bedrooms", "Furnishing"];

  // ✅ Handle search click
  const handleSearch = () => {
  //   if (searchCity.trim() === "") {
  //     alert("Please enter a city name");
  //     return;
  //   }
  //   localStorage.setItem("selectedCity", searchCity); // store in localStorage
    navigate("/PropertyListingPage"); // navigate to your listing page
  };

  return (
    <div className="search-filter-container">
      {/* Search Bar */}
      <div className="search-box">
        <div
          className="filter-toggle"
          onClick={() => setShowFilters(!showFilters)}
        >
          <FiFilter className="icon" style={{ backgroundColor: " #e6f2fb" }} />
        </div>

        <div className="input-wrapper">
          <input
            type="text"
            placeholder="Search by City..."
            value={searchCity}
            onChange={(e) => setSearchCity(e.target.value)}
            style={{
              fontSize: "20px",
              color: "#333",
              backgroundColor: "transparent",
              border: "none",
              outline: "none",
              width: "100%",
            }}
          />
        </div>

        {/* <FiSettings className="icon" style={{ backgroundColor: " #e6f2fb" }} />
        <FiMic className="icon" style={{ backgroundColor: " #e6f2fb" }} /> */}

        <Button
          type="primary"
          icon={<SearchIcon />}
          style={{
            fontWeight: 600,
            fontFamily: "Poppins",
            backgroundColor: "#2b6cb0",
            borderColor: "#2b6cb0",
            padding: "20px 20px 20px 10px",
            boxShadow: "0 2px 8px rgba(0, 0, 0, 0.1)",
            fontSize: 18,
          }}
          onClick={handleSearch}
        >
          Search
        </Button>
      </div>

      {/* Filter Panel */}
      {showFilters && (
        <div className="filter-panel"
        style={{
          backgroundColor: "white",
          padding: 10,
          borderRadius: 8,
          width: "790px",
          marginTop: 5,
        }}
        >
          {/* Buy / Rent / New Launch Options */}
          <div className="tabs-section">
            {tabs.map((tab) => (
              <button
                key={tab}
                className={`tab-btn ${activeTab === tab ? "active" : ""}`}
                onClick={() => setActiveTab(tab)}
              >
                {tab}
              </button>
            ))}
          </div>

          <div className="filter-section">
            <div className="filter-grid">
              {filters.map((filter) => (
                <div key={filter} className="filter-item">
                  <label htmlFor={`${filter.toLowerCase()}-select`}>
                    {filter}
                  </label>
                  <select id={`${filter.toLowerCase()}-select`}>
                    <option value="">Select</option>
                    {filter === "Budget" && (
                      <>
                        <option value="0-50">0 - 50 Lakhs</option>
                        <option value="50-1">50 Lakhs - 1 Cr</option>
                        <option value="1-2">1 Cr - 2 Cr</option>
                        <option value="2+">2 Cr +</option>
                      </>
                    )}
                    {filter === "City" && (
                      <>
                        <option value="pune">Pune</option>
                        <option value="mumbai">Mumbai</option>
                        <option value="nagpur">Nagpur</option>
                      </>
                    )}
                    {filter === "Bedrooms" && (
                      <>
                        <option value="1">1 BHK</option>
                        <option value="2">2 BHK</option>
                        <option value="3">3 BHK</option>
                      </>
                    )}
                    {filter === "Furnishing" && (
                      <>
                        <option value="furnished">Furnished</option>
                        <option value="semi-furnished">Semi-Furnished</option>
                        <option value="unfurnished">Unfurnished</option>
                      </>
                    )}
                  </select>
                </div>
              ))}
            </div>
          </div>

          <div className="filter-section" style={{ display: "flex" }}>
            <div className="amenities">
              <h3>Amenities</h3>
              <p className="amenity-item">Property Details</p>
              <p className="amenity-item">Location</p>
              <p className="amenity-item">Property Age</p>
            </div>

            <div className="types">
              <h3>Property Types</h3>
              <div className="types-grid">
                {[
                  "House",
                  "Flat",
                  "Villa",
                  "Plot",
                  "Bungalow",
                  "Land",
                  "Apartment",
                  "Commercial",
                ].map((type, index) => (
                  <div className="type-item" key={index}>
                    <CheckBoxSharpIcon
                      style={{ marginRight: "8px", color: "blue" }}
                    />
                    <span>{type}</span>
                  </div>
                ))}
              </div>
            </div>
          </div>

          <div className="filter-actions">
            <Button
              type="primary"
              icon={<SaveIcon />}
              style={{
                fontWeight: 600,
                fontFamily: "Poppins",
                backgroundColor: "#2b6cb0",
                borderColor: "#2b6cb0",
                padding: "15px 10px 15px 10px",
                boxShadow: "0 2px 8px rgba(0, 0, 0, 0.1)",
                marginRight: 10,
              }}
            >
              Save Filter
            </Button>
            <Button
              type="primary"
              icon={<ClearIcon />}
              style={{
                fontWeight: 600,
                fontFamily: "Poppins",
                backgroundColor: "#00bcd4",
                borderColor: "#00bcd4",
                padding: "15px 10px 15px 10px",
                boxShadow: "0 2px 8px rgba(0, 0, 0, 0.1)",
              }}
              onClick={() => setShowFilters(!showFilters)}
            >
              Clear
            </Button>
          </div>
        </div>
      )}
    </div>
  );
};

export default SearchBar;
