import React, { useState, useEffect } from "react";
import "./Navbar.css";
import { FiMenu, FiX } from "react-icons/fi";
import { useNavigate } from "react-router-dom";
import LoginModal from "../Modal/LoginModal/LoginModal";
// import toast from "react-hot-toast";
// import axios from "axios";
// import { encryptParam, decryptParam } from "../../utils/encript";

const Navbar = () => {
  const [menuOpen, setMenuOpen] = useState(false);
  const navigate = useNavigate();
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [regData, setRegData] = useState({
    contactno: "",
    password: "",
  });

  // const [builderInfo, setBuilderInfo] = useState(null);

  const HandleLogin = () => {
    setIsModalOpen(true);
  };

  const handleEmailClick = () => {
    console.log("Continue with email");
  };

  // ============ Login & Save Encrypted ID ============
  // const handleLoginClick = async () => {
  //   try {
  //     const { contactno, password } = regData;

  //     if (!contactno || !password) {
  //       toast.error("Please fill out all required fields.");
  //       return;
  //     }

  //     const numericContact = Number(contactno);
  //     if (isNaN(numericContact)) {
  //       toast.error("Contact number must be numeric.");
  //       return;
  //     }

  //     const response = await axios.post(
  //       "http://localhost:3001/builder-masters/login",
  //       {
  //         contactno: numericContact,
  //         password,
  //       }
  //     );

  //     if (response.data.message === "Login successful") {
  //       toast.success("Login successful");
  //       console.log(response.data.builder.builderId);

  //       const builderId = response.data.builder.builderId; // backend must return builderId
  //       console.log(builderId);
  //       const encryptedId = encryptParam(builderId);
  //       localStorage.setItem("token", response.data.token);

  //       navigate(`/dashboard/${encryptedId}`);
  //       setIsModalOpen(false);
  //       setRegData({ contactno: "", password: "" });

  //       // Immediately fetch builder info
  //       fetchBuilderInfo(encryptedId);
  //     } else {
  //       toast.error(response.data.message || "Login failed");
  //     }
  //   } catch (error) {
  //     console.error(error);
  //     toast.error("Login error");
  //   }
  // };
  const handleLoginClick = async () => {
    navigate("/dashboard");
  };

  // ============ Fetch builder info on mount ============
  // const fetchBuilderInfo = async (idFromStorage) => {
  //   try {
  //     const encryptedId = idFromStorage || localStorage.getItem("builderId");
  //     if (!encryptedId) return;

  //     const decryptedId = decryptParam(encryptedId);
  //     const res = await axios.get(
  //       `http://localhost:3001/builder-masters/${decryptedId}`
  //     );
  //     setBuilderInfo(res.data);
  //   } catch (err) {
  //     console.error("Failed to fetch builder info", err);
  //   }
  // };

  // useEffect(() => {
  //   fetchBuilderInfo();
  // }, []);

  const handlePostClick = () => {
    navigate("/postproperty");
  };

  return (
    <div className="navbar">
      <div className="navbar-top">
        <div className="logo-section">
          <div className="logo-circle-big" />
          <h3 className="logo-text poppins-text" style={{ color: "white" }}>
            Lello <br />
            Properties
          </h3>
        </div>

        <div className="support">
          <div className="support-icon-small" />
          <div className="support-text">
            <span>Call Support</span>
            <br />
            <strong>180-180-22-55</strong>
          </div>
          &emsp;
          <button onClick={HandleLogin} className="login-btn">
            Login / Sign Up
          </button>
        </div>
      </div>

      <div className="navbar-bottom">
        <div className={`nav-links ${menuOpen ? "open" : ""}`}>
          <a href="#">For Buyers</a>
          <a href="#">For Tenants</a>
          <a href="#">For Owners</a>
          <a href="#">For Dealers/Builders</a>
        </div>

        <button className="post-btn" onClick={handlePostClick}>
          Post your Property
        </button>

        <div className="menu-toggle" onClick={() => setMenuOpen(!menuOpen)}>
          {menuOpen ? <FiX /> : <FiMenu />}
        </div>
      </div>

      {/* 👤 Show builder name if logged in */}
      {/* {builderInfo && (
        <div className="text-white text-center mt-2">
          Welcome, <strong>{builderInfo.name}</strong>
        </div>
      )} */}

      {/* Login Modal */}
      <LoginModal
        open={isModalOpen}
        regData={regData}
        setRegData={setRegData}
        handleLoginClick={handleLoginClick}
        handleEmailClick={handleEmailClick}
        close={() => setIsModalOpen(false)}
      />
    </div>
  );
};

export default Navbar;
