


import React, { useState } from 'react';
import './Navbar.css';
import { FiMenu, FiX } from 'react-icons/fi';
import { useNavigate } from 'react-router-dom';

const Navbar = () => {
    const [menuOpen, setMenuOpen] = useState(false);
    const navigate = useNavigate();



    const handlePostClick = () => {
        navigate('/postproperty');
    };

    return (
        <div className="navbar">
            <div className="navbar-top">
                <div className="logo-section">
                    <div className="logo-circle-big" />
                    <h2 className="logo-text" style={{ color: 'white' }}>Lello <br />Properties</h2>
                </div>

                <div className="support">
                    <div className="support-icon-small" />
                    <div className="support-text">
                        <span>Call Support</span><br />
                        <strong>180-180-22-55</strong>
                    </div>&emsp;
                    <button className="login-btn">Login/ Sign Up</button>
                </div>
            </div>

            <div className="navbar-bottom">
                <div className={`nav-links ${menuOpen ? 'open' : ''}`}>
                    <a href="#">For Buyers</a>
                    <a href="#">For Tenants</a>
                    <a href="#">For Owners</a>
                    <a href="#">For Dealers/Builders</a>
                </div>

                <button className="post-btn" onClick={handlePostClick}>
                    Post your Property
                </button>

                <div className="menu-toggle" onClick={() => setMenuOpen(!menuOpen)}>
                    {menuOpen ? <FiX /> : <FiMenu />}
                </div>
            </div>
        </div>
    );
};

export default Navbar;


