// HeroNavBar.jsx
import React, { useState, useEffect } from "react";
import {
  Menu,
  Dropdown,
  Button,
  Badge,
  Grid,
  Drawer,
  Row,
  Col,
  Typography,
  Divider,
} from "antd";
import {
  DownOutlined,
  MenuOutlined,
  HomeOutlined,
  ShoppingCartOutlined,
  UserOutlined,
  TeamOutlined,
} from "@ant-design/icons";
import { useNavigate } from "react-router-dom";
import PersonSharpIcon from "@mui/icons-material/PersonSharp";
import LelloImg from "../../assets/Logo/Lello-Logo.png";
import "./HeroNavBar.css";
import axios from "axios";
import { URL } from "../../config";

const { useBreakpoint } = Grid;
const { Text, Title } = Typography;

const HeroNavBar = ({ onLoginClick, user }) => {
  const navigate = useNavigate();
  const [drawerVisible, setDrawerVisible] = useState(false);
  const [isScrolled, setIsScrolled] = useState(false);
  const [logoUrl, setLogoUrl] = useState(""); // Dynamic logo
  const screens = useBreakpoint();
  const sellerId = localStorage.getItem("sellerId");
  console.log(sellerId);
  const userId = localStorage.getItem("userId");
  console.log(userId);

  const isLoggedIn =
    !!user ||
    (sellerId && sellerId !== "null" && sellerId !== "undefined") ||
    (userId && userId !== "null" && userId !== "undefined");

  useEffect(() => {
    fetchLogo();

    const handleScroll = () => {
      setIsScrolled(window.scrollY > 50);
    };

    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const fetchLogo = async () => {
    try {
      const response = await axios.get(`${URL}/logo-masters`);
      console.log("Logo data:", response.data);

      if (response.data.length > 0) {
        // Adjust this path based on how your backend serves files
        setLogoUrl(`${URL}/uploads/logos/${response.data[0].logoImage}`);
      }
    } catch (error) {
      console.error("Error fetching logo:", error);
    }
  };

  // 🔹 Reusable button for login/user
  // 🔹 Reusable button for login/user
  const renderLoginButton = () => {
    if (isLoggedIn) {
      const menu = (
        <Menu>
          {sellerId && sellerId !== "null" && sellerId !== "undefined" && (
            <Menu.Item key="dashboard" onClick={() => navigate("/dashboard")}>
              Dashboard
            </Menu.Item>
          )}
          <Menu.Item
            key="logout"
            className="no-login-trigger" // 👈 add this
            onClick={() => {
              localStorage.removeItem("sellerId");
              localStorage.removeItem("userId");
              localStorage.removeItem("user");

              window.location.reload(); // refresh navbar state
            }}
          >
            Logout
          </Menu.Item>
        </Menu>
      );

      return (
        <Dropdown overlay={menu} trigger={["click"]}>
          <Button
            type="default"
            icon={<UserOutlined />}
            style={{ padding: "20px 30px", fontWeight: 500 }}
          >
            Account
          </Button>
        </Dropdown>
      );
    } else {
      return (
        <Badge.Ribbon text="FREE" color="green">
          <Button
            type="primary"
            icon={<PersonSharpIcon />}
            onClick={onLoginClick}
            style={{ padding: "20px 60px 20px 10px", fontWeight: 500 }}
          >
            Login / Signup
          </Button>
        </Badge.Ribbon>
      );
    }
  };

  const searchPropertyMenu = (
    <div
      style={{
        width: 600,
        padding: 20,
        background: "#fff",
        boxShadow: "0 8px 24px rgba(0,0,0,0.15)",
        borderRadius: 12,
      }}
    >
      <Row gutter={16}>
        <Col span={12}>
          <div style={{ display: "flex", flexDirection: "column", gap: 10 }}>
            <Title
              level={5}
              style={{
                color: "#2b6cb0",
                borderBottom: "2px solid #1890ff",
                paddingBottom: 4,
              }}
            >
              Search Property
            </Title>
            <Button
              type="link"
              icon={<ShoppingCartOutlined style={{ color: "#1890ff" }} />}
              style={{
                color: "#000",
                fontWeight: 600,
                display: "flex",
                justifyContent: "start",
              }}
            >
              Buy
            </Button>
            <Button
              type="link"
              icon={<UserOutlined style={{ color: "#1890ff" }} />}
              style={{
                color: "#000",
                fontWeight: 600,
                display: "flex",
                justifyContent: "start",
              }}
            >
              Tenants
            </Button>
            <Divider />
            <Text>
              Contact us toll free on <br />
              <Text type="success" strong>
                1999 41 99099
              </Text>
            </Text>
          </div>
        </Col>
        <Col span={12}>
          <div
            style={{
              background: "#e6f7ff",
              borderRadius: 8,
              padding: 16,
              textAlign: "center",
            }}
          >
            <img
              src="https://cdn-icons-png.flaticon.com/512/5087/5087579.png"
              alt="Login/Signup"
              style={{ width: "40%", margin: "0 auto" }}
            />
            <Text strong>Free Login and Sign Up!</Text>
            <Text>Access your account and manage your listings with ease</Text>
            <Badge.Ribbon text="FREE" color="green" style={{ marginTop: 10 }}>
              <Button
                type="primary"
                onClick={onLoginClick}
                block
                icon={<PersonSharpIcon />}
                style={{
                  marginTop: 10,
                  padding: "20px 40px 20px 0px",
                  fontWeight: 500,
                }}
              >
                Login / Signup
              </Button>
            </Badge.Ribbon>
          </div>
        </Col>
      </Row>
    </div>
  );

  const toSellMenu = (
    <div
      style={{
        width: 600,
        padding: 20,
        background: "#fff",
        boxShadow: "0 8px 24px rgba(0,0,0,0.15)",
        borderRadius: 12,
      }}
    >
      <Row gutter={16}>
        <Col span={12}>
          <div style={{ display: "flex", flexDirection: "column", gap: 10 }}>
            <Title
              level={5}
              style={{
                color: "#2b6cb0",
                borderBottom: "2px solid #1890ff",
                paddingBottom: 4,
              }}
            >
              To Sell
            </Title>
            <Button
              type="link"
              icon={<HomeOutlined style={{ color: "#1890ff" }} />}
              style={{
                color: "#000",
                fontWeight: 600,
                display: "flex",
                justifyContent: "start",
              }}
            >
              Owner
            </Button>
            <Button
              type="link"
              icon={<TeamOutlined style={{ color: "#1890ff" }} />}
              style={{
                color: "#000",
                fontWeight: 600,
                display: "flex",
                justifyContent: "start",
              }}
            >
              Builder
            </Button>
            <Divider />
            <Text>
              Contact us toll free on <br />
              <Text type="success" strong>
                1999 41 99099
              </Text>
            </Text>
          </div>
        </Col>
        <Col span={12}>
          <div
            style={{
              background: "#e6f7ff",
              borderRadius: 8,
              padding: 16,
              textAlign: "center",
            }}
          >
            <img
              src="https://cdn-icons-png.flaticon.com/512/5087/5087579.png"
              alt="Login/Signup"
              style={{ width: "40%", margin: "0 auto" }}
            />
            <Text strong>Free Login and Sign Up!</Text>
            <Text>Access your account and manage your listings with ease</Text>
            <Badge.Ribbon text="FREE" color="green" style={{ marginTop: 10 }}>
              <Button
                type="primary"
                onClick={onLoginClick}
                block
                icon={<PersonSharpIcon />}
                style={{
                  marginTop: 10,
                  padding: "20px 40px 20px 0px",
                  fontWeight: 500,
                }}
              >
                Login / Signup
              </Button>
            </Badge.Ribbon>
          </div>
        </Col>
      </Row>
    </div>
  );

  const renderMenuLinks = () => (
    <>
      <Dropdown overlay={searchPropertyMenu} arrow>
        <a
          onClick={(e) => e.preventDefault()}
          style={{
            fontSize: "18px",
            fontWeight: 600,
            color: "black",
            textTransform: "uppercase",
          }}
        >
          Search Property <DownOutlined />
        </a>
      </Dropdown>
      <a
        onClick={() => navigate("/rent")}
        style={{
          fontSize: "18px",
          fontWeight: 600,
          color: "black",
          textTransform: "uppercase",
        }}
      >
        To Rent
      </a>
      <Dropdown overlay={toSellMenu} arrow>
        <a
          onClick={(e) => e.preventDefault()}
          style={{
            fontSize: "18px",
            fontWeight: 600,
            color: "black",
            textTransform: "uppercase",
          }}
        >
          To Sell <DownOutlined />
        </a>
      </Dropdown>
    </>
  );

  return (
    <div className={`hero-navbar ${isScrolled ? "scrolled" : ""}`}>
      <div className="logo-section" onClick={() => navigate("/")}>
        <img
          src={logoUrl || LelloImg}
          alt="LeLLo"
          className="logo-img"
          onError={(e) => {
            e.target.onerror = null;
            e.target.src = LelloImg;
          }}
        />
      </div>

      {screens.md ? (
        <div className="nav-menu">{renderMenuLinks()}</div>
      ) : (
        <>
          <Button
            icon={<MenuOutlined className="menu-icon" />}
            type="text"
            onClick={() => setDrawerVisible(true)}
          />
          <Drawer
            title="Menu"
            placement="right"
            onClose={() => setDrawerVisible(false)}
            open={drawerVisible}
          >
            <div className="mobile-menu">
              {renderMenuLinks()}
              {renderLoginButton()}
            </div>
          </Drawer>
        </>
      )}

      {screens.md && (
        <div className="action-section">{renderLoginButton()}</div>
      )}
    </div>
  );
};

export default HeroNavBar;
