import React, { useState } from "react";
import {
  IconButton,
  Drawer,
  List,
  ListItem,
  ListItemButton,
  ListItemText,
  Box,
  Typography,
} from "@mui/material";
import MenuIcon from "@mui/icons-material/Menu";
import CloseIcon from "@mui/icons-material/Close";
import { Link as RouterLink } from "react-router-dom";
import clinicLogo from "../../../assets/Logo/Logo-lello2.jfif";

const MobileNav = ({ navLinks }) => {
  const [open, setOpen] = useState(false);
  const toggleDrawer = (state) => () => setOpen(state);

  return (
    <>
      <IconButton
        color="inherit"
        onClick={toggleDrawer(true)}
        sx={{ display: { xs: "block", md: "none" } }}
      >
        <MenuIcon />
      </IconButton>

      <Drawer
        anchor="right"
        open={open}
        onClose={toggleDrawer(false)}
        PaperProps={{
          sx: { width: 280, p: 2 },
        }}
      >
        {/* Close */}
        <Box sx={{ display: "flex", justifyContent: "flex-end" }}>
          <IconButton onClick={toggleDrawer(false)}>
            <CloseIcon />
          </IconButton>
        </Box>

        {/* Logo */}
        <Box sx={{ textAlign: "center", my: 2 }}>
          <img src={clinicLogo} alt="Logo" width="100%" />
        </Box>

        {/* Links */}
        <List>
          {navLinks.map((link) => (
            <ListItem key={link.path} disablePadding>
              <ListItemButton
                component={RouterLink}
                to={link.path}
                onClick={toggleDrawer(false)}
                sx={{ textAlign: "center" }}
              >
                <ListItemText
                  primary={
                    <Typography
                      sx={{
                        fontFamily: "Poppins",
                        fontSize: "18px",
                        color: "#255670",
                      }}
                    >
                      {link.label}
                    </Typography>
                  }
                />
              </ListItemButton>
            </ListItem>
          ))}
        </List>
      </Drawer>
    </>
  );
};

export default MobileNav;
