// import React, { useState, useEffect } from "react";
// import {
//     Box,
//     Typography,
//     TextField,
//     Button,
//     FormControl,
//     RadioGroup,
//     FormControlLabel,
//     Radio,
//     Checkbox,
//     Autocomplete,
//     Modal,
// } from "@mui/material";
// import axios from "axios";
// import { URL } from '../../config'
// import { Container } from "react-bootstrap";
// import { Row, Col } from "antd";
// import { FileAddOutlined } from "@ant-design/icons";
// import { useNavigate } from "react-router-dom";
// import { useSnackbar } from 'notistack';   // ✅ Import Notistack hook

// // ✅ Added phone prop so mobile comes from OTP/state
// const LoginModal = ({ open, onClose, phone }) => {
//     const [name, setName] = useState("");
//     const [email, setEmail] = useState("");
//     const [mobileno, setMobileno] = useState("");
//     const [isAgent, setIsAgent] = useState("no");
//     const [isAgreed, setIsAgreed] = useState(false);
//     const [whoYouAre, setWhoYouAre] = useState(null);
//     const [identityOptions, setIdentityOptions] = useState([]);
//     const [cityOptions, setCityOptions] = useState([]);
//     const [selectedCity, setSelectedCity] = useState(null);
//     const navigate = useNavigate();
//     const { enqueueSnackbar } = useSnackbar();  // ✅ useSnackbar hook

//     // ✅ Prefill mobile from props (OTP screen/state)
//     useEffect(() => {
//         if (phone) {
//             setMobileno(phone);
//         }
//     }, [phone]);

//     // ✅ Fetch user types
//     useEffect(() => {
//         axios
//             .get(`${URL}/usertypes`)
//             .then((res) => {
//                 setIdentityOptions(res.data);
//             })
//             .catch((err) => {
//                 console.error("Error fetching user types:", err);
//             });
//     }, []);

//     // ✅ Fetch cities
//     useEffect(() => {
//         axios
//             .get(`${URL}/city-masters`)
//             .then((res) => {
//                 setCityOptions(res.data);
//             })
//             .catch((err) => {
//                 console.error("Error fetching city list:", err);
//                 enqueueSnackbar(' Something went wrong during registration.Error fetching city list:', err, { variant: 'error' });

//             });
//     }, []);

//     // ✅ Submit Logic
//     const handleSubmit = async () => {
//         if (!name || !email || !mobileno || !isAgreed) {
//             alert("Please fill all required fields!");
//             enqueueSnackbar('Please fill all required fields!', { variant: 'warning' });

//             return;
//         }

//         const identity = whoYouAre?.userId;
//         const cityId = selectedCity?.cityId;

//         try {
//             if (identity !== 1) {
//                 const sellerData = {
//                     fkuserId: identity,
//                     fkcityId: cityId,
//                     fkpackageId: 1,
//                     paymentFlag: 0,
//                     sellerName: name,
//                     sellerGmail: email,
//                     sellerMobile: Number(mobileno),
//                     lastChanged: new Date().toISOString(),
//                 };

//                 const res = await axios.post(
//                     `${URL}/seller-masters-text`,
//                     sellerData
//                 );

//                 localStorage.setItem("sellerId", res.data.sellerId);
//                 // alert("✅ Seller text fields saved!");
//                 enqueueSnackbar(`Seller text fields saved!`, { variant: 'success' });

//                 navigate('/dashboard');

//             }
//             if (identity == 1) {
//                 const buyerData = {
//                     fkusertypeId: identity,
//                     buyerName: name,
//                     buyerMobile:Number(mobileno),
//                     buyerGmail:email,
//                     fkcityId:cityId,
//                     lastChanged: new Date().toISOString(),

//                 }
//                 const buyerRes =await  axios.post(`${URL}/buyer-masters`, buyerData);
//                 console.log(buyerRes.data);
//                 localStorage.setItem("buyerId" , buyerRes.data.buyerId)
//                  enqueueSnackbar(`buyer registered successfully!`, { variant: 'success' });

//             }
//             onClose();
//         } catch (error) {
//             console.error(error);
//             // alert("❌ Something went wrong during registration.");
//             enqueueSnackbar(' Something went wrong during registration.', { variant: 'error' });

//         }
//     };

//     return (
//         <Modal open={open} onClose={onClose}>
//             <Container fluid>
//                 <Box display="flex" justifyContent="center" alignItems="center" minHeight="100vh">
//                     <Box
//                         sx={{
//                             width: { xs: "95%", sm: "80%", md: "60%", lg: "35%" }, // ✅ wider form
//                             bgcolor: "white",
//                             p: { xs: 2, sm: 3 },
//                             borderRadius: 2,
//                             boxShadow: 3,
//                             maxHeight: "90vh",
//                             overflowY: "hidden", // ✅ hide scrollbar
//                         }}
//                     >
//                         {/* Heading */}
//                         <Box textAlign="center" mb={3}>
//                             <Typography variant="h5" sx={{ color: "#0d47a1", fontWeight: "bold" }}>
//                                 Create Account
//                             </Typography>

//                         </Box>

//                         {/* Full Name */}
//                         <Row gutter={[0, 16]}>
//                             <Col span={24}>
//                                 <TextField
//                                     fullWidth
//                                     variant="outlined"
//                                     placeholder="Full Name"
//                                     label="Full Name"
//                                     value={name}
//                                     onChange={(e) => setName(e.target.value)}
//                                     size="small"
//                                     InputLabelProps={{ shrink: true }}
//                                     sx={{
//                                         '& label': {
//                                             color: '#0d47a1',
//                                             fontWeight: 'bold',
//                                         },
//                                         '& label.Mui-focused': {
//                                             color: '#1976d2',
//                                         },
//                                         '& .MuiOutlinedInput-root': {
//                                             '& fieldset': {
//                                                 borderColor: '#ccc',
//                                             },
//                                             '&:hover fieldset': {
//                                                 borderColor: '#999',
//                                             },
//                                             '&.Mui-focused fieldset': {
//                                                 borderColor: '#1976d2',
//                                             },
//                                         },
//                                     }}
//                                 />

//                             </Col>
//                         </Row>

//                         {/* Email */}
//                         <Row style={{ marginTop: "16px" }}>
//                             <Col span={24}>
//                                 <TextField
//                                     fullWidth
//                                     variant="outlined"
//                                     label="Email Id"
//                                     placeholder="Email"

//                                     value={email}
//                                     onChange={(e) => setEmail(e.target.value)}
//                                     type="email"
//                                     size="small"
//                                     InputLabelProps={{ shrink: true }}
//                                     sx={{
//                                         '& label': {
//                                             color: '#0d47a1',
//                                             fontWeight: 'bold',
//                                         },
//                                         '& label.Mui-focused': {
//                                             color: '#1976d2',
//                                         },
//                                         '& .MuiOutlinedInput-root': {
//                                             '& fieldset': {
//                                                 borderColor: '#ccc',
//                                             },
//                                             '&:hover fieldset': {
//                                                 borderColor: '#999',
//                                             },
//                                             '&.Mui-focused fieldset': {
//                                                 borderColor: '#1976d2',
//                                             },
//                                         },
//                                     }}
//                                 />

//                             </Col>
//                         </Row>

//                         {/* Mobile */}
//                         {/* Mobile */}
//                         <Row style={{ marginTop: "16px" }}>
//                             <Col span={24}>
//                                 <TextField
//                                     fullWidth
//                                     variant="outlined"
//                                     placeholder="Mobile No"
//                                     label="Mobile No"
//                                     inputProps={{ maxLength: 10 }}
//                                     value={phone}
//                                     onChange={(e) => {
//                                         const value = e.target.value;
//                                         if (/^\d{0,10}$/.test(value)) {
//                                             setMobileno(value);
//                                         }
//                                     }}
//                                     size="small"
//                                     InputLabelProps={{ shrink: true }}
//                                     sx={{
//                                         '& label': {
//                                             color: '#0d47a1',
//                                             fontWeight: 'bold',
//                                         },
//                                         '& label.Mui-focused': {
//                                             color: '#1976d2',
//                                         },
//                                         '& .MuiOutlinedInput-root': {
//                                             '& fieldset': {
//                                                 borderColor: '#ccc',
//                                             },
//                                             '&:hover fieldset': {
//                                                 borderColor: '#999',
//                                             },
//                                             '&.Mui-focused fieldset': {
//                                                 borderColor: '#1976d2',
//                                             },
//                                         },
//                                     }}
//                                 />
//                             </Col>
//                         </Row>

//                         {/* City */}
//                         <Row style={{ marginTop: "16px" }}>
//                             <Col span={24}>
//                                 <Autocomplete
//                                     options={cityOptions}
//                                     getOptionLabel={(option) => option.cityName || ""}
//                                     value={selectedCity}
//                                     onChange={(event, newValue) => setSelectedCity(newValue)}
//                                     renderInput={(params) => (
//                                         <TextField
//                                             {...params}
//                                             label="City"
//                                             placeholder="Select City"
//                                             size="small"
//                                             InputLabelProps={{ shrink: true }}
//                                             sx={{
//                                                 '& label': {
//                                                     color: '#0d47a1',
//                                                     fontWeight: 'bold',
//                                                 },
//                                                 '& label.Mui-focused': {
//                                                     color: '#1976d2',
//                                                 },
//                                                 '& .MuiOutlinedInput-root': {
//                                                     '& fieldset': {
//                                                         borderColor: '#ccc',
//                                                     },
//                                                     '&:hover fieldset': {
//                                                         borderColor: '#999',
//                                                     },
//                                                     '&.Mui-focused fieldset': {
//                                                         borderColor: '#1976d2',
//                                                     },
//                                                 },
//                                             }}
//                                         />
//                                     )}
//                                 />
//                             </Col>
//                         </Row>

//                         {/* Real Estate Agent */}
//                         <Row style={{ marginTop: "10px" }}>
//                             <Col span={24}>
//                                 <FormControl component="fieldset">
//                                     <p style={{ marginBottom: "5px" }}>Are you a real estate agent?</p>
//                                     <RadioGroup
//                                         row
//                                         value={isAgent}
//                                         onChange={(e) => setIsAgent(e.target.value)}
//                                     >
//                                         <FormControlLabel value="yes" control={<Radio />} label="Yes" />
//                                         <FormControlLabel value="no" control={<Radio />} label="No" />
//                                     </RadioGroup>
//                                 </FormControl>
//                             </Col>
//                         </Row>

//                         {/* Who You Are */}
//                         {isAgent === "yes" && (
//                             <Box mt={2}>
//                                 <Typography variant="subtitle1" gutterBottom>
//                                     Select Who You Are
//                                 </Typography>
//                                 <Box display="flex" flexWrap="wrap" gap={1}>
//                                     {identityOptions.map((option) => (
//                                         <Button
//                                             key={option.userId}
//                                             variant={whoYouAre?.userId === option.userId ? "contained" : "outlined"}
//                                             size="small"
//                                             onClick={() => setWhoYouAre(option)}
//                                         >
//                                             {option.username}
//                                         </Button>
//                                     ))}
//                                 </Box>
//                             </Box>
//                         )}

//                         {/* Terms + Button */}
//                         <Row gutter={[16, 16]} align="middle" style={{ marginTop: "10px" }}>
//                             <Col xs={24} sm={12}>
//                                 <FormControlLabel
//                                     control={
//                                         <Checkbox
//                                             checked={isAgreed}
//                                             onChange={(e) => setIsAgreed(e.target.checked)}
//                                         />
//                                     }
//                                     label="I agree to all terms"
//                                 />
//                             </Col>
//                         </Row>

//                         {/* Submit Button */}
//                         <Row>
//                             <Col xs={24} style={{ textAlign: "center", marginTop: "10px" }}>
//                                 <Button
//                                     variant="contained"
//                                     color="primary"
//                                     startIcon={<FileAddOutlined style={{ fontSize: 16 }} />}
//                                     sx={{
//                                         borderRadius: "8px",
//                                         boxShadow: "0px 4px 8px rgba(0, 0, 0, 0.2)",
//                                         "&:hover": {
//                                             backgroundColor: "#125ea3",
//                                             transform: "translateY(-2px)",
//                                             boxShadow: "0px 6px 12px rgba(0, 0, 0, 0.3)",
//                                         },
//                                     }}
//                                     onClick={handleSubmit}
//                                 >
//                                     Create Account
//                                 </Button>
//                             </Col>
//                         </Row>
//                     </Box>
//                 </Box>
//             </Container>
//         </Modal>
//     );
// };

// export default LoginModal;

import React, { useState, useEffect } from "react";
import {
  Box,
  Typography,
  TextField,
  Button,
  FormControl,
  RadioGroup,
  FormControlLabel,
  Radio,
  Checkbox,
  Autocomplete,
  Modal,
  IconButton,
} from "@mui/material";
import axios from "axios";
import { URL } from "../../config";
import { Container } from "react-bootstrap";
import { Row, Col } from "antd";
import { FileAddOutlined } from "@ant-design/icons";
import { useNavigate } from "react-router-dom";
import { useSnackbar } from "notistack";
import CloseIcon from "@mui/icons-material/Close";

const LoginModal = ({ open, onClose, phone }) => {
  const [name, setName] = useState("");
  const [email, setEmail] = useState("");
  const [mobileno, setMobileno] = useState("");
  // const [isAgent, setIsAgent] = useState("no");
  const [isAgreed, setIsAgreed] = useState(false);
  const [whoYouAre, setWhoYouAre] = useState(null);
  const [identityOptions, setIdentityOptions] = useState([]);
  const [cityOptions, setCityOptions] = useState([]);
  const [selectedCity, setSelectedCity] = useState(null);

  const navigate = useNavigate();
  const { enqueueSnackbar } = useSnackbar();

  useEffect(() => {
    if (phone) {
      setMobileno(phone);
    }
  }, [phone]);

  useEffect(() => {
    axios
      .get(`${URL}/usertypes`)
      .then((res) => setIdentityOptions(res.data))
      .catch((err) => console.error("Error fetching user types:", err));
  }, []);

  useEffect(() => {
    axios
      .get(`${URL}/city-masters`)
      .then((res) => setCityOptions(res.data))
      .catch((err) => {
        console.error("Error fetching city list:", err);
        enqueueSnackbar("Error fetching city list", { variant: "error" });
      });
  }, []);

  const handleSubmit = async () => {
    if (!name || !email || !mobileno || !isAgreed) {
      enqueueSnackbar("Please fill all required fields!", {
        variant: "warning",
      });
      return;
    }

    const identity = whoYouAre?.userId;
    const cityId = selectedCity?.cityId;

    try {
      if (identity !== 1) {
        const sellerData = {
          fkuserId: identity,
          fkcityId: cityId,
          fkpackageId: 1,
          paymentFlag: 0,
          sellerName: name,
          sellerGmail: email,
          sellerMobile: Number(mobileno),
          lastChanged: new Date().toISOString(),
        };

        const res = await axios.post(`${URL}/seller-masters-text`, sellerData);
        localStorage.setItem("sellerId", res.data.sellerId);
        enqueueSnackbar(`Seller account created!`, { variant: "success" });

        navigate("/dashboard");
      } else {
        const buyerData = {
          fkusertypeId: identity,
          buyerName: name,
          buyerMobile: Number(mobileno),
          buyerGmail: email,
          fkcityId: cityId,
          lastChanged: new Date().toISOString(),
        };

        const buyerRes = await axios.post(
          `${URL}/buyer-masters/text`,
          buyerData,
        );
        localStorage.setItem("buyerId", buyerRes.data.buyerId);
        enqueueSnackbar(`Buyer registered successfully!`, {
          variant: "success",
        });
      }

      onClose();
    } catch (error) {
      console.error(error);
      enqueueSnackbar("Registration failed. Please try again.", {
        variant: "error",
      });
    }
  };

  return (
    // <Modal open={open} onClose={onClose}>
    <Modal
      className="registration-modal" // ✅ add this
      open={open}
      onClose={() => {}}
      disableEscapeKeyDown
      hideBackdrop={false}
    >
      <Container fluid>
        <Box
          display="flex"
          justifyContent="center"
          alignItems="center"
          minHeight="100vh"
          p={2}
        >
          <Box
            sx={{
              width: {
                xs: "95%",
                sm: "90%",
                md: "70%",
                lg: "40%",
                maxWidth: 450,
              },
              bgcolor: "white",
              p: 4,
              borderRadius: 3,
              boxShadow: 5,
              maxHeight: "90vh",
              overflowY: "auto",
            }}
          >
            {/* Title */}
            <Box
              display="flex"
              justifyContent="space-between"
              alignItems="center"
            >
              {" "}
              <Typography
                variant="h5"
                textAlign="center"
                sx={{ color: "#0d47a1", fontWeight: "bold", mb: 3 }}
              >
                Create Account
              </Typography>
              <IconButton onClick={onClose}>
                <CloseIcon />
              </IconButton>
            </Box>

            {/* Full Name */}
            <TextField
              fullWidth
              label="Full Name"
              placeholder="Full Name"
              value={name}
              onChange={(e) => setName(e.target.value)}
              size="small"
              sx={{ mb: 2 }}
              InputLabelProps={{ shrink: true }}
            />

            {/* Email */}
            <TextField
              fullWidth
              label="Email Id"
              placeholder="Email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              size="small"
              sx={{ mb: 2 }}
              InputLabelProps={{ shrink: true }}
            />

            {/* Mobile */}
            <TextField
              fullWidth
              label="Mobile No"
              placeholder="Mobile No"
              inputProps={{ maxLength: 10 }}
              value={mobileno}
              onChange={(e) => {
                const value = e.target.value;
                if (/^\d{0,10}$/.test(value)) setMobileno(value);
              }}
              size="small"
              sx={{ mb: 2 }}
              InputLabelProps={{ shrink: true }}
            />

            {/* City */}
            <Autocomplete
              disablePortal // ✅ keep dropdown inside modal
              options={cityOptions}
              getOptionLabel={(option) => option.cityName || ""}
              value={selectedCity}
              onChange={(event, newValue) => setSelectedCity(newValue)}
              renderInput={(params) => (
                <TextField
                  {...params}
                  label="City"
                  placeholder="Select City"
                  size="small"
                  sx={{ mb: 2 }}
                  InputLabelProps={{ shrink: true }}
                />
              )}
            />

            {/* Real Estate Agent */}

            <Box mb={2}>
              <Typography variant="subtitle1">Select Who You Are</Typography>
              <Box display="flex" flexWrap="wrap" gap={1} mt={1}>
                {identityOptions.map((option) => (
                  <Button
                    key={option.userId}
                    variant={
                      whoYouAre?.userId === option.userId
                        ? "contained"
                        : "outlined"
                    }
                    size="small"
                    onClick={() => setWhoYouAre(option)}
                  >
                    {option.username}
                  </Button>
                ))}
              </Box>
            </Box>

            {/* Terms */}
            <FormControlLabel
              control={
                <Checkbox
                  checked={isAgreed}
                  onChange={(e) => setIsAgreed(e.target.checked)}
                />
              }
              label="I agree to all terms"
              sx={{ mb: 3 }}
            />

            {/* Submit Button */}
            <Button
              variant="contained"
              color="primary"
              startIcon={<FileAddOutlined />}
              fullWidth
              sx={{
                backgroundColor: "#0d47a1",
                fontWeight: "bold",
                padding: "10px",
                borderRadius: "8px",
                "&:hover": { backgroundColor: "#1565c0" },
              }}
              onClick={handleSubmit}
            >
              CREATE ACCOUNT
            </Button>
          </Box>
        </Box>
      </Container>
    </Modal>
  );
};

export default LoginModal;
