// src/Components/Modal/MembershipPromptModal/MembershipPromptModal.jsx
import React from "react";
import { Modal, Button, Typography } from "antd";
import { CrownOutlined, CloseOutlined } from "@ant-design/icons";
import { useNavigate } from "react-router-dom";

const { Title, Paragraph } = Typography;

const MembershipPromptModal = ({ open, onClose }) => {
  const navigate = useNavigate();

  const handleMembershipNavigation = () => {
    navigate("/membership");
    onClose();
  };

  return (
    <Modal
      open={open}
      onCancel={onClose}
      footer={null}
      closeIcon={<CloseOutlined style={{ fontSize: 18 }} />}
      width={500}
      centered
      style={{
        borderRadius: 12,
        overflow: "hidden",
      }}
      bodyStyle={{
        padding: "30px 20px",
        borderRadius: 12,
      }}
    >
      <div style={{ textAlign: "center" }}>
        <div
          style={{
            display: "flex",
            justifyContent: "center",
            marginBottom: 20,
          }}
        >
          <div
            style={{
              width: 70,
              height: 70,
              borderRadius: "50%",
              backgroundColor: "rgba(244, 182, 46, 0.1)",
              display: "flex",
              alignItems: "center",
              justifyContent: "center",
            }}
          >
            <CrownOutlined
              style={{ fontSize: 36, color: "#f4b62e" }}
            />
          </div>
        </div>

        <Title level={3} style={{ marginBottom: 16, color: "#333",  fontFamily: "Poppins" }}>
          Membership Required
        </Title>

        <Paragraph style={{ fontSize: 16, color: "#666", marginBottom: 24,  fontFamily: "Poppins" }}>
          To view property details and contact owners directly, you need to
          purchase a membership plan. Get unlimited access to premium features
          and exclusive properties.
        </Paragraph>

        <div
          style={{
            backgroundColor: "rgba(81, 174, 214, 0.1)",
            padding: "16px 20px",
            borderRadius: 8,
            marginBottom: 24,
          }}
        >
          <Title level={5} style={{ marginBottom: 8, color: "#51aed6", fontFamily: "Poppins" }}>
            Membership Benefits:
          </Title>
          <ul style={{ textAlign: "left", color: "#555", paddingLeft: 20,  fontFamily: "Poppins" }}>
            <li>View unlimited property details</li>
            <li>Contact property owners directly</li>
            <li>Add unlimited properties to cart</li>
            <li>Priority customer support</li>
          </ul>
        </div>

        <div style={{ display: "flex", gap: 12, justifyContent: "center" }}>
          <Button
            type="primary"
            size="large"
            onClick={handleMembershipNavigation}
            style={{
              backgroundColor: "rgb(25, 118, 210)",
              borderColor: "rgb(22 75 128)",
              borderRadius: 8,
              fontWeight: 600,
              minWidth: 140,
               fontFamily: "Poppins"
            }}
          >
            View Plans
          </Button>
          <Button
            size="large"
            onClick={onClose}
            style={{
              borderRadius: 8,
              fontWeight: 600,
              minWidth: 100,
               fontFamily: "Poppins"
            }}
          >
            Maybe Later
          </Button>
        </div>
      </div>
    </Modal>
  );
};

export default MembershipPromptModal;