import React from 'react';
import { Spin } from 'antd';
import { LoadingOutlined } from '@ant-design/icons';

// Replace this with your actual image import
import IMG from '../../assets/loader/output-onlinegiftools.gif'
// const IMG = 'https://via.placeholder.com/150/4F46E5/FFFFFF?text=Loading';

function Loader() {
  return (
    <div style={{
      position: 'fixed',
      top: 0,
      left: 0,
      width: '100vw',
      height: '100vh',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center',
      alignItems: 'center',
      backgroundColor: 'rgba(255, 255, 255, 0.95)',
      backdropFilter: 'blur(8px)',
      zIndex: 9999,
      gap: '24px'
    }}>
      {/* Loader Image Container */}
      <div style={{
        position: 'relative',
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center'
      }}>
        {/* Outer animated ring */}
        <div style={{
          position: 'absolute',
          width: '200px',
          height: '200px',
          border: '3px solid #f0f0f0',
          borderTop: '3px solid #1890ff',
          borderRadius: '50%',
          animation: 'spin 1.5s linear infinite'
        }} />
        
        {/* Image */}
        <div style={{
          width: '150px',
          height: '150px',
          borderRadius: '16px',
          overflow: 'hidden',
          boxShadow: '0 8px 32px rgba(0, 0, 0, 0.1)',
          backgroundColor: '#fff',
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center'
        }}>
          <img 
            src={IMG} 
            alt="Loading" 
            style={{
              width: '100%',
              height: '100%',
              objectFit: 'contain',
            //   margin: 150,
            }}
          />
        </div>
      </div>

      {/* Loading text with Ant Design Spin */}
      <div style={{
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        gap: '12px'
      }}>
        <Spin 
          indicator={<LoadingOutlined style={{ fontSize: 32, color: '#1890ff' }} spin />}
        />
        <div style={{
          fontSize: '18px',
          fontWeight: 500,
          color: '#262626',
          letterSpacing: '0.5px'
        }}>
          Loading...
        </div>
        <div style={{
          fontSize: '14px',
          color: '#8c8c8c'
        }}>
          Please wait while we prepare everything
        </div>
      </div>

      <style>{`
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
      `}</style>
    </div>
  );
}

export default Loader;