import React, { useRef, useEffect } from "react";
import {
  Box,
  Grid,
  Typography,
  Button,
  Card,
  CardMedia,
  IconButton,
  useTheme,
  useMediaQuery,
} from "@mui/material";
import PlayCircleIcon from "@mui/icons-material/PlayCircle";
import InstagramIcon from "@mui/icons-material/Instagram";
import FacebookIcon from "@mui/icons-material/Facebook";
import YouTubeIcon from "@mui/icons-material/YouTube";
import InstagramYoutubeSection1 from "../../assets/InstagramYoutube/house.jpg";
import InstagramYoutubeSection2 from "../../assets/Header/HeroIMG11.jpg";
import InstagramYoutubeSection3 from "../../assets/Header/HeroIMG12.jpg";
import socialmediabackgroundimages from "../../assets/InstagramYoutube/socialmediabackgroundimages3.png";
// Import your local video file
import TestVideo from "../../assets/Videos/YouTube1.mp4";
import Insta1 from "../../assets/Videos/Insta1.mp4";
import Insta2 from "../../assets/Videos/Insta2.mp4";
import Insta3 from "../../assets/Videos/Insta3.mp4";
// Swiper imports
import { Swiper, SwiperSlide } from "swiper/react";
import { EffectCoverflow, Autoplay, Pagination } from "swiper/modules";
import "swiper/css";
import "swiper/css/effect-coverflow";
import "swiper/css/pagination";
const images = {
  insta: [
    InstagramYoutubeSection1,
    InstagramYoutubeSection2,
    InstagramYoutubeSection3,
    InstagramYoutubeSection1,
    InstagramYoutubeSection2,
    InstagramYoutubeSection3,
  ],
};

const InstagramYoutubeSection = () => {
  const theme = useTheme();
  const isSmall = useMediaQuery(theme.breakpoints.down("sm"));
  const videoRef = useRef(null);
  useEffect(() => {
    // Intersection Observer for auto-play when section is visible
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            // Section is visible, play video
            if (videoRef.current) {
              videoRef.current.play().catch((error) => {
                console.log("Auto-play was prevented:", error);
              });
            }
          } else {
            // Section is not visible, pause video
            if (videoRef.current) {
              videoRef.current.pause();
            }
          }
        });
      },
      {
        threshold: 0.5, // Trigger when 50% of the section is visible
      }
    );
    const section = document.getElementById("youtube-section");
    if (section) {
      observer.observe(section);
    }
    return () => {
      if (section) {
        observer.unobserve(section);
      }
    };
  }, []);
  return (
   <Box
  id="youtube-section"
  sx={{
    backgroundImage: `url(${socialmediabackgroundimages})`, // <-- your background image
    backgroundSize: "cover",       // cover the entire box
    backgroundPosition: "center",  // center the image
    backgroundRepeat: "no-repeat", // avoid repeating
    py: { xs: 6, sm: 8 },
    px: { xs: 2, sm: 6, md: 10 },
    textAlign: "center",
    position: "relative",
    "&::before": {
      content: '""',
      position: "absolute",
      top: 0,
      left: 0,
      right: 0,
      bottom: 0,
      background:
        "radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.3) 0%, transparent 50%), " +
        "radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.2) 0%, transparent 50%)",
      pointerEvents: "none",
    },
  }}
>

      {/* Decorative sparkles */}
      <Box
        sx={{
          position: "absolute",
          right: { xs: 10, md: 40 },
          top: { xs: 10, md: 20 },
          display: "flex",
          gap: 1.5,
          zIndex: 1,
        }}
      >
        <IconButton
          sx={{
            color: "#E4405F", // Instagram pink
            "&:hover": { transform: "scale(1.1)" },
            transition: "all 0.3s ease",
          }}
          aria-label="Instagram"
        >
          <InstagramIcon fontSize="large" />
        </IconButton>
        <IconButton
          sx={{
            color: "#1877F2", // Facebook blue
            "&:hover": { transform: "scale(1.1)" },
            transition: "all 0.3s ease",
          }}
          aria-label="Facebook"
        >
          <FacebookIcon fontSize="large" />
        </IconButton>
        <IconButton
          sx={{
            color: "#FF0000", // YouTube red
            "&:hover": { transform: "scale(1.1)" },
            transition: "all 0.3s ease",
          }}
          aria-label="YouTube"
        >
          <YouTubeIcon fontSize="large" />
        </IconButton>
      </Box>
      {/* Title */}
      <Typography
        variant="h4"
        sx={{
          fontFamily: "serif",
          color: "red",
          fontWeight: "bold",
          mb: 6,
          mt: 4,
          fontSize: { sm: "1.7rem", md: "2.125rem" },
          position: "relative",
          zIndex: 1,
          fontFamily: "Poppins",
        }}
      >
        Instagram And You Tube
      </Typography>
      <Grid
        container
        spacing={4}
        alignItems="center"
        justifyContent="center"
        sx={{ position: "relative", zIndex: 1 }}
      >
        {/* Left: YouTube Section */}
        <Grid item xs={12} md={4}>
          <Card
            sx={{
              backgroundColor: "#d8e8f8",
              borderRadius: 4,
              overflow: "hidden",
              boxShadow: "0 6px 16px rgba(0,0,0,0.1)",
              p: 1,
              mb: 3,
            }}
          >
            <Box position="relative">
              <video
                ref={videoRef}
                style={{
                  width: "100%",
                  height: isSmall ? "250px" : "310px",
                  objectFit: "cover",
                  borderRadius: "12px",
                  fontFamily: "Poppins",
                }}
                loop
                muted
                playsInline
              >
                <source src={TestVideo} type="video/mp4" />
                Your browser does not support the video tag.
              </video>
            </Box>
          </Card>
          <Typography
            variant="h5"
            sx={{
              color: "#d32f2f",
              fontWeight: "bold",
              mb: 2,
              lineHeight: 1.3,
            }}
          >
            Hear from Our <br /> Consultants
          </Typography>
        </Grid>
        {/* Divider Line  */}
        <Grid
          item
          md={0.5}
          sx={{
            display: { xs: "none", md: "flex" },
            justifyContent: "center",
            alignSelf: "stretch",
          }}
        >
          <Box
            sx={{
              width: "1.5px",
              height: 350,
              backgroundColor: "#d9d1d1bd",
              mx: "auto",
            }}
          />
        </Grid>
        {/* Right: Instagram Videos (Swiper Slider 3D Coverflow) */}
        <Grid item xs={12} md={7.5}>
          <Swiper
            effect="coverflow"
            grabCursor={true}
            centeredSlides={true}
            slidesPerView={isSmall ? 1.2 : 3}
            loop={true}
            autoplay={{
              delay: 2500,
              disableOnInteraction: false,
            }}
            coverflowEffect={{
              rotate: 50,
              stretch: 0,
              depth: 100,
              modifier: 1,
              slideShadows: true,
            }}
            pagination={{ clickable: true }}
            modules={[EffectCoverflow, Autoplay, Pagination]}
            style={{
              width: isSmall ? 300 : 650,
              paddingBottom: "50px",
            }}
          >
            {images.insta.map((img, index) => (
              <SwiperSlide key={index}>
                <Card
                  sx={{
                    borderRadius: 4,
                    overflow: "hidden",
                    position: "relative",
                    boxShadow: "0 6px 16px rgba(0,0,0,0.1)",
                    transition: "transform 0.3s ease",
                    "&:hover": {
                      transform: "translateY(-6px)",
                    },
                    width: 200,
                    height: isSmall ? 300 : 330,
                    mx: "auto",
                  }}
                >
                  <CardMedia
                    component="img"
                    image={img}
                    alt={`Instagram video ${index + 1}`}
                    sx={{
                      width: "100",
                      height: "100%",
                      objectFit: "none",
                    }}
                  />
                  <IconButton
                    sx={{
                      position: "absolute",
                      top: "50%",
                      left: "50%",
                      transform: "translate(-50%, -50%)",
                      color: "black",
                    }}
                  >
                    <PlayCircleIcon
                      sx={{
                        fontSize: 65,
                        backgroundColor: "lightblue",
                        borderRadius: "50%",
                      }}
                    />
                  </IconButton>
                </Card>
              </SwiperSlide>
            ))}
          </Swiper>
        </Grid>
      </Grid>
    </Box>
  );
};
export default InstagramYoutubeSection;
