import React from "react";
import { Button } from "antd";
import { Swiper, SwiperSlide } from "swiper/react";
import { EffectCoverflow, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/effect-coverflow";
import "./Gallery.css";
import IMG1 from "../../assets/Gallery/314f0b70047e1562df536876d7e81805.jpg"
import IMG2 from "../../assets/Gallery/5cc84aea3a9772c9587fa73680d721a4.jpg"
import IMG3 from "../../assets/Gallery/bdfbc4d7de92ef60cfc95f8308b1bf1d.jpg"
import IMG4 from "../../assets/Gallery/dcb4eff2da7bb86cd757c38fe8cd97f0.jpg"
import IMG5 from "../../assets/Gallery/Project-Photo-20-Saniket-WYCE-Exclucity-Pune-5426259_1067_1600.jpg"
import IMG6 from "../../assets/Gallery/Project-Photo-21-Saniket-WYCE-Exclucity-Pune-5426259_854_1600.jpg"
import IMG7 from "../../assets/Gallery/Project-Photo-34-Saniket-WYCE-Exclucity-Pune-5426259_853_1600.jpg"
import start from "../../assets/Gallery/stars.png"


const images = [ IMG1, IMG2, IMG3, IMG4, IMG5, IMG6, IMG7, IMG1, IMG2, IMG3, ];

const Gallery = () => {
  return (
    <div
      className="gallery-section"
      style={{
        backgroundImage: "url(/images/gallery-bg.jpg)",
        backgroundSize: "cover",
        backgroundPosition: "center",
        padding: "40px 20px",
        borderRadius: "10px",
        position: "relative",
      }}
    >
      {/* Stars top-left */}
      <div className="decor-stars" style={{ position: "absolute", top: "20px", left: 0 }}>
        
       <img src={start} alt="Decorative stars" />
      </div>

      {/* Circles top-right */}
      <div className="decor-circles" style={{ position: "absolute", top: "20px", right: 0 }}>
        <svg width="44" height="44" viewBox="0 0 44 44">
          <circle cx="11" cy="11" r="11" fill="#FDC161" />
          <circle cx="33" cy="11" r="5" fill="#FDC161" />
          <circle cx="33" cy="33" r="7" fill="#FDC161" opacity="0.8" />
        </svg>
      </div>

      <h2 className="gallery-subtitle">Gallery</h2>
      <h1 className="gallery-title">Immersive Beautiful Co-working Space gallery</h1>

      <div
        className="gallery-bg"
      >
        <Swiper
          effect={"coverflow"}
          grabCursor={true}
          centeredSlides={true}
          slidesPerView={5}
          spaceBetween={10}
          loop={true}
          autoplay={{ delay: 0, disableOnInteraction: false }}
          speed={3000}
          coverflowEffect={{
            rotate: 0, // rotation handled via CSS
            stretch: 0,
            depth: 200,
            modifier: 1,
            slideShadows: false,
          }}
          modules={[EffectCoverflow, Autoplay]}
        >
          {images.map((img, index) => (
            <SwiperSlide key={index}>
              <div
                className="gallery-img"
                style={{
                  backgroundImage: `url(${img})`,
                }}
              />
            </SwiperSlide>
          ))}
        </Swiper>
      </div>

      <p className="gallery-desc">
        Design, Develop, Manufacture, and Supply of Valves and Allied Products
        to the total satisfaction of its customers through innovation,
        world-class leadership, employee development, and social responsibility.
      </p>

      <Button type="primary" shape="round" size="large" className="view-btn">
        View All
      </Button>
    </div>
  );
};

export default Gallery;
