import React from "react";
import "./ExpertHelp.css";
import { FiPhoneCall } from "react-icons/fi";
import { motion } from "framer-motion";
import shoeImage from "../../assets/architect.avif"; // Your shoe image
import bgImage from "../../assets/whitefour.avif";

const ExpertHelp = () => {
  return (
    <section className="expert-wrapper">
      <motion.div
        className="expert-card"
        style={{ backgroundImage: `url(${bgImage})` }}
        initial={{ opacity: 0, y: 80 }}
        whileInView={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.8, ease: "easeOut" }}
        viewport={{ once: true }}
      >
        {/* LEFT TEXT */}
        <motion.div
          className="expert-left"
          initial={{ x: -50, opacity: 0 }}
          whileInView={{ x: 0, opacity: 1 }}
          transition={{ duration: 0.7, delay: 0.2 }}
          viewport={{ once: true }}
        >
          <h3 className="expert-sub"><b>Need Help?</b></h3>
          <h2 className="expert-heading">Talk to Our Property Expert</h2>
          <p className="expert-desc">
            Get personalized guidance to find your dream home, investment
            opportunities, and best property deals.
          </p>
          <motion.button
            className="expert-btn"
            whileHover={{ scale: 1.05 }}
            whileTap={{ scale: 0.95 }}
          >
            <FiPhoneCall size={20} /> Contact Now
          </motion.button>
        </motion.div>

        {/* CENTER IMAGE */}
        <motion.div
          className="expert-img-wrap"
          initial={{ scale: 0.8, opacity: 0 }}
          whileInView={{ scale: 1, opacity: 1 }}
          transition={{ duration: 0.8, delay: 0.3 }}
          viewport={{ once: true }}
        >
          {/* Oval background */}
          <span className="oval-bg"></span>

          {/* Petals */}
          <span className="petal petal1"></span>
          <span className="petal petal2"></span>
          <span className="petal petal3"></span>

          {/* Animated dots */}
          <span className="dot dot1"></span>
          <span className="dot dot2"></span>
          <span className="dot dot3"></span>
          <span className="dot dot4"></span>

          {/* Circular Shoe Image */}
          <motion.img
            src={shoeImage}
            alt="Shoe"
            className="shoe-img"
            whileHover={{ scale: 1.05, rotate: 2 }}
            animate={{ y: [0, -10, 0] }}
            transition={{ duration: 3, repeat: Infinity, ease: "easeInOut" }}
          />
        </motion.div>

        {/* RIGHT CONTACT */}
        <motion.div
          className="expert-right"
          initial={{ x: 50, opacity: 0 }}
          whileInView={{ x: 0, opacity: 1 }}
          transition={{ duration: 0.7, delay: 0.4 }}
          viewport={{ once: true }}
        >
          <div className="phone-icon">
            <FiPhoneCall size={22} color="#fff" />
          </div>
          <div className="phone-info">
            <span className="phone-label">Call Anytime</span>
            <p className="phone-text">+123 321 456 9871</p>
          </div>
        </motion.div>
      </motion.div>
    </section>
  );
};

export default ExpertHelp;
