

import React, { useState, useEffect } from 'react';
import './ExclusiveProperty.css';
import { FiSearch } from 'react-icons/fi';
import buildingImage from '../../assets/PostIMG/PostImg_17.jpg';
import logoImage from '../../assets/Logo/Lello-Logo.png';
import profileImage from '../../assets/PostIMG/PostImg_26.jpg';

const ExclusiveProperty = () => {
    const [currentIndex, setCurrentIndex] = useState(0);

    const slides = [
        {
            id: 1,
            title: "Looking for best place to sell",
            subtitle: "List your property with us",
            buttonText: "Get Started",
            searchText: "Search",
            highlight: "BIG",
            time: "05:47 PM",
            textColor: '#2d3748',
            isImage: false,           // Slide 1
            leftColor: '#2B6CB0',
            rightImage: profileImage
        },
        {
            id: 2,
            title: "Exclusive Properties",
            subtitle: "Place to Live",
            buttonText: "Explore",
            textColor: '#ffffff',
            isImage: true,            // Slide 2 
            image: buildingImage,
            logo: logoImage
        }
    ];

    useEffect(() => {
        const interval = setInterval(() => {
            setCurrentIndex(prev => (prev + 1) % slides.length);
        }, 5000);
        return () => clearInterval(interval);
    }, [slides.length]);

    const goToSlide = index => setCurrentIndex(index);

    return (
        <div className="carousel-container">
            <div
                className="carousel-track"
                style={{
                    transform: `translateX(-${currentIndex * 100}%)`,
                    transition: 'transform 0.8s cubic-bezier(0.65, 0, 0.35, 1)'
                }}
            >
                {slides.map(slide => (
                    <div
                        key={slide.id}
                        className={`carousel-slide ${slide.isImage ? 'image-slide' : ''}`}
                        style={{
                            background: slide.isImage ? 'none' : undefined,
                            color: slide.textColor,
                            position: 'relative',
                            minWidth: '100%',
                            display: 'flex',
                            padding: slide.isImage ? '0 80px' : '0'
                        }}
                    >
                        {/*** Slide 1***/}
                        {!slide.isImage ? (
                            <>
                                <div
                                    style={{
                                        width: '50%',
                                        backgroundColor: slide.leftColor,
                                        display: 'flex',
                                        justifyContent: 'center',
                                        alignItems: 'center',
                                        padding: '0 80px'
                                    }}
                                >
                                    <div className="slide-content">
                                        <h1>{slide.title}</h1>
                                        <h2 style={{ color: 'white' }}>{slide.subtitle}</h2>
                                        <button className="action-button">{slide.buttonText}</button>


                                    </div>
                                </div>
                                <div
                                    style={{
                                        width: '50%',
                                        backgroundImage: `url(${slide.rightImage})`,
                                        backgroundSize: 'cover',
                                        backgroundPosition: 'center'
                                    }}
                                />
                            </>
                        ) : (
                            /*** Slide 2 ***/
                            <>
                                <img
                                    src={slide.image}
                                    alt="Slide"
                                    className="slide-img"
                                />
                                <img
                                    src={slide.image}
                                    alt="Slide"
                                    className="slide-img"
                                />
                                <div className="triangle-shadow" />
                                <div className="slide-content">
                                    {slide.logo && (
                                        <img
                                            src={slide.logo}
                                            alt="Logo"
                                            className="slide-logo"
                                            style={{ height: '60px', width: '60px' }}
                                        />
                                    )}
                                    <h1>{slide.title}</h1>
                                    <h2 style={{ color: 'white' }}>{slide.subtitle}</h2>
                                    <button className="action-button">{slide.buttonText}</button>
                                </div>
                            </>
                        )}
                    </div>
                ))}
            </div>

            <div className="carousel-dots">
                {slides.map((_, idx) => (
                    <div
                        key={idx}
                        className={`dot ${idx === currentIndex ? 'active' : ''}`}
                        onClick={() => goToSlide(idx)}
                    />
                ))}
            </div>
        </div>
    );
};

export default ExclusiveProperty;
