import React from "react";
import { Row, Col, Typography } from "antd";
import { motion } from "framer-motion";
import "./mission.css";
import MissionIMG from "../../../Assets/AboutUs/mission.png";

const { Title } = Typography;

const Mission = () => {
  return (
    <section className="mission-wrapper">
      <Row gutter={[64, 64]} align="middle">

       
        <Col xs={24} md={12} className="mission-images">
          <motion.img
            src={MissionIMG}
            alt="Interior"
            className="m-img-single"
            initial={{ opacity: 0, x: -60, scale: 0.85 }} 
            whileInView={{ opacity: 1, x: 0, scale: 1 }}
            viewport={{ once: false, amount: 0.25 }}
            transition={{ duration: 0.7 }}
          />
        </Col>

     
        <Col xs={24} md={12} className="mission-text">
          <motion.div
            initial={{ opacity: 0, x: 60 }} 
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: false, amount: 0.25 }}
            transition={{ duration: 0.7 }}
          >
            <Title level={1} className="mission-title">
              Our Mission
            </Title>

            <div className="mission-points">
              <div className="mission-point">
                <span className="mission-highlight">Simplify Real Estate</span>
                <p>
                  Providing accurate information, transparent communication, and dependable services to help clients make confident property decisions.
                </p>
              </div>

              <div className="mission-point">
                <span className="mission-highlight">Build Trust</span>
                <p>
                  Long-term relationships based on honesty, integrity, and professionalism, ensuring clarity throughout the real estate journey.
                </p>
              </div>

              <div className="mission-point">
                <span className="mission-highlight">Innovative Solutions</span>
                <p>
                  Combining deep market knowledge with modern tools to deliver efficient and value-driven real estate experiences.
                </p>
              </div>

              <div className="mission-point">
                <span className="mission-highlight">Sustainable Growth</span>
                <p>
                  Focusing on sustainable growth for clients, partners, and communities while raising industry service standards.
                </p>
              </div>
            </div>
          </motion.div>
        </Col>

      </Row>
    </section>
  );
};

export default Mission;
