import React from "react";
import { Row, Col, Typography } from "antd";
import { motion } from "framer-motion";
import "./features.css";
import bg1 from "../../../assets/AboutUs/bg1.svg";
import bg2 from "../../../assets/AboutUs/bg2.svg";
import bg3 from "../../../assets/AboutUs/bg3.svg";
import bg4 from "../../../assets/AboutUs/bg4.svg";

const { Title, Paragraph } = Typography;

const Features = () => {
  const data = [
    {
      title: "Prime location",
      desc: "Enjoy a prime location with seamless access to business hubs, lifestyle conveniences, and city landmarks.",
      img: bg1,
    },
    {
      title: "Spacious interiors",
      desc: "Experience open layouts that blend comfort, elegance, and seamless modern living.",
      img: bg2,
    },
    {
      title: "Advanced security",
      desc: "Stay protected with advanced security systems that ensure safety, peace of mind, and reliable living.",
      img: bg3,
    },
    {
      title: "Sustainable living",
      desc: "Embrace sustainable living with eco-friendly designs, energy efficiency, and green community spaces.",
      img: bg4,
    },
  ];

  return (
    <section className="features-wrapper">
      <Row gutter={[64, 64]} align="top">

        {/* LEFT TEXT */}
        <Col xs={24} md={10}>
          <Title level={2} className="features-heading">
            The smarter choice for your dream home
          </Title>
          <Paragraph className="features-subtext">
            Discover the smarter choice for your dream home, where modern design
            meets comfort, convenience, and value to create a lifestyle tailored
            to your aspirations.
          </Paragraph>
        </Col>

     
        <Col xs={24} md={14}>
          <div className="features-grid">
            {data.map((item, index) => (
             <motion.div
  key={index}
  className="feature-card horizontal"
  initial={{ opacity: 0, y: 24 }}
  whileInView={{ opacity: 1, y: 0 }}
  whileHover={{
    scale: 1.04,
    boxShadow: "0 18px 36px rgba(0,0,0,0.14)",
  }}
  transition={{
    type: "spring",
    stiffness: 420,  
    damping: 26,      
    mass: 0.8,        
  }}
>

             
                <img
                  src={item.img}
                  alt=""
                  className="feature-icon-img"
                />

            
                <div className="feature-content">
                  <h3>{item.title}</h3>
                  <p>{item.desc}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </Col>
      </Row>
    </section>
  );
};

export default Features;
