import React from "react";
import { Row, Col, Typography, Collapse } from "antd";
import { UpOutlined } from "@ant-design/icons";
import "./faqsection.css";
import faqImage from "../../../assets/AboutUs/faq.webp";

const { Title } = Typography;
const { Panel } = Collapse;

const items = [
  {
    key: "1",
    question: "What are the steps to buying a home?",
    answer:
      "Buying a home typically begins with financial planning and budgeting to understand affordability. The next step is obtaining pre-approval from a lender, which strengthens your buying position. After this, you search for suitable properties and make an offer once you find the right one. Inspections and negotiations follow to ensure value and safety. Finally, the process ends with documentation, legal checks, and closing the purchase.",
  },
  {
    key: "2",
    question: "How do I get pre-approved for financing?",
    answer:
      "Pre-approval involves submitting financial documents such as income proof, bank statements, and credit history to a lender. The lender evaluates your repayment capacity and creditworthiness. Based on this review, they issue a pre-approval letter outlining your loan eligibility. This helps you set a realistic budget and speeds up the buying process. It also increases seller confidence in your offer.",
  },
  {
    key: "3",
    question: "How long does the home buying process usually take?",
    answer:
      "The buying timeline varies depending on financing type and market conditions. On average, it can take anywhere between 30 to 60 days from offer acceptance to closing. Factors like inspections, legal documentation, and loan approvals affect duration. Delays may occur if issues are found during inspections or appraisal. Proper planning helps ensure a smoother and faster process.",
  },
  {
    key: "4",
    question: "How do I choose the right neighborhood?",
    answer:
      "Choosing the right neighborhood depends on lifestyle, commute, and long-term plans. Consider proximity to workplaces, schools, healthcare, and shopping areas. Safety, infrastructure, and community development play an important role. Research future growth potential and property value trends. Visiting the area at different times of day also helps you make an informed decision.",
  },
  {
    key: "5",
    question: "What are the benefits of using a real estate agent?",
    answer:
      "A real estate agent provides market insights and property recommendations based on your needs. They assist with negotiations to help secure the best price and terms. Agents also manage paperwork, legal coordination, and timelines. Their experience helps avoid costly mistakes during the process. Overall, they simplify the buying journey and save time and effort.",
  },
  {
    key: "6",
    question: "What costs should I consider besides the property price?",
    answer:
      "Apart from the property price, buyers should consider registration fees and stamp duty. Legal charges, inspection costs, and home insurance are also important. Loan processing fees and taxes may apply depending on financing. Maintenance charges and society fees should be reviewed in advance. Planning for these expenses ensures financial readiness.",
  },
  {
    key: "7",
    question: "Is it better to buy or rent a home?",
    answer:
      "Buying a home builds long-term equity and provides stability. Renting offers flexibility and lower upfront costs. The right choice depends on financial readiness, lifestyle, and future plans. Market conditions and interest rates also influence decisions. Evaluating both options carefully helps determine what suits your situation best.",
  },
];

const FaqSection = () => {
  return (
    <section className="faq-bg">
      <div className="faq-wrapper">
        <Row gutter={0} align="stretch">
     
          <Col xs={24} sm={24} md={14} className="faq-card-col">
            <div className="faq-card">
              <Title level={1} className="faq-title">
                Frequently asked
                <br />
                questions
              </Title>

              <Collapse
                accordion
                bordered={false}
                defaultActiveKey={["1"]}
                expandIconPosition="end"
                expandIcon={({ isActive }) => (
                  <UpOutlined
                    rotate={isActive ? 0 : 180}
                    className="faq-arrow-icon"
                  />
                )}
                className="faq-collapse"
              >
                {items.map((item) => (
                  <Panel header={item.question} key={item.key}>
                    <p className="faq-answer">{item.answer}</p>
                  </Panel>
                ))}
              </Collapse>
            </div>
          </Col>

       
          <Col xs={0} sm={0} md={10} className="faq-image-col">
            <img
              src={faqImage}
              alt="Client thinking about real estate"
              className="faq-image"
            />
          </Col>
        </Row>
      </div>
    </section>
  );
};

export default FaqSection;
