import React from "react";
import { Row, Col, Typography } from "antd";
import { motion } from "framer-motion";
import "./corevalues.css";
import Innovation from "../../../assets/AboutUs/innovation.png";
import Excellence from "../../../Assets/AboutUs/excellence.png";
import Reliability from "../../../Assets/AboutUs/relability.png";
import Commitment from "../../../Assets/AboutUs/comitment.png";

const { Title } = Typography;

const values = [
  {
    id: 1,
    icon: Innovation,
    title: "Innovation",
    text: "We bring modern ideas and smart solutions to real estate.",
    color: "#F59E0B",
  },
  {
    id: 2,
    icon: Excellence,
    title: "Excellence",
    text: "We deliver high-quality service with attention to detail.",
    color: "#EF4444",
  },
  {
    id: 3,
    icon: Reliability,
    title: "Reliability",
    text: "Clients trust us for transparent and dependable guidance.",
    color: "#10B981",
  },
  {
    id: 4,
    icon: Commitment,
    title: "Commitment",
    text: "We stay committed to long-term value and relationships.",
    color: "#3B82F6",
  },
];

const fadeUp = {
  hidden: { opacity: 0, y: 40, scale: 0.95 },
  visible: { 
    opacity: 1, 
    y: 0, 
    scale: 1, 
    transition: { type: "spring", stiffness: 120, damping: 15 } 
  },
};

const CoreValues = () => {
  return (
    <section className="values-wrapper">

      {/* Decorative star */}
      <svg className="decor-star" width="120" height="120" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M50 0 C52 22 56 26 78 28 C56 30 52 34 50 56 C48 34 44 30 22 28 C44 26 48 22 50 0Z"
          fill="#3B82F6"
        />
      </svg>

      {/* Decorative circles */}
      <svg className="decor-circle" width="70" height="70" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg">
        <circle cx="42" cy="18" r="7" fill="#F59E0B" />
        <circle cx="26" cy="34" r="5" fill="#FBBF24" />
        <circle cx="46" cy="40" r="3" fill="#FDBA74" />
      </svg>

      <motion.div
        className="values-heading"
        variants={fadeUp}
        initial="hidden"
        whileInView="visible"
        viewport={{ once: false, amount: 0.3 }}
      >
        <Title level={2} className="values-title">
          Core Values Driving Our Real Estate Success
        </Title>
      </motion.div>

      <Row gutter={[32, 32]} justify="center">
        {values.map((item, index) => (
          <Col key={item.id} xs={24} sm={12} md={12} lg={6}>
            <motion.div
              className="value-card"
              style={{ borderLeft: `6px solid ${item.color}` }}
              variants={fadeUp}
              initial="hidden"
              whileInView="visible"
              viewport={{ once: false, amount: 0.3 }}
              transition={{ delay: index * 0.1 }}
              whileHover={{ scale: 1.05, transition: { duration: 0.3 } }}
            >
              <div className="card-content">
                <div
                  className="card-icon"
                  style={{ backgroundColor: item.color + "33" }}
                >
                  <img src={item.icon} alt={item.title} />
                </div>
                <div className="card-text-block">
                  <h3 className="card-title">{item.title}</h3>
                  <p className="card-text">{item.text}</p>
                </div>
              </div>
            </motion.div>
          </Col>
        ))}
      </Row>
    </section>
  );
};

export default CoreValues;
