import React from "react";
import { Routes, Route } from "react-router-dom";
import "bootstrap/dist/css/bootstrap.min.css";
import "bootstrap/dist/js/bootstrap.bundle.min.js";
import { SnackbarProvider } from "notistack";

import Navbar from "./Components/Navbar/Navbar";
import Home from "./Pages/Home";
import PostPropertyPage from "./Pages/PostPropertyPage";
import PostPropertyPageForm from "./Pages/PostPropertyPageForm/PostPropertyPageForm";
import PropertyListingPage from "./Pages/PropertyList/PropertyListingPage";
import Propertyinfo from "./Pages/Propertyinfo/Propertyinfo";

import DashboardLayout from "./Dashboard/DashboardLayout";
import MyDashboard from "./Dashboard/pages/MyDashboard";
import PostNewProperty from "./Dashboard/pages/PostNewProperty";
import ManageListings from "./Dashboard/pages/ManageListings";
import BuyerEnquiries from "./Dashboard/pages/BuyerEnquiries";
import PropertyAnalytics from "./Dashboard/pages/PropertyAnalytics";
import AdsManagement from "./Dashboard/pages/AdsManagement";
import Profile from "./Dashboard/pages/Profile";
import EditProfile from "./Dashboard/pages/EditProfile";
import PropertyForm2 from "./Components/PropertyForm/PropertyForm2";
import PublishProperty from "./Dashboard/pages/PublishProperty";
import UserEnquiry from "./Pages/UserEnquiry";
import AdsForm from "./Dashboard/pages/AdsForm";
import PropertyForm3 from "./Components/PropertyForm/PropertyForm3";
import Membership from "./Pages/Membership/Membership";
import PaymentCallback from "./Pages/Membership/PaymentCallback";
import AboutUs from "./Pages/AboutUs/AboutUs";
import ContactUs from "./Pages/ContactUs/ContactUs";
import AddToCart from "./Pages/AddToCart/AddToCart";
import SavedProperties from "./Pages/AddToCart/SavedProperties";
import ViewProperty from "./Pages/ViewProperty/ViewProperty";
// import ImageUploadForm from './Components/ImageUploadform';
function App() {
  // const location = useLocation();
  // const isHome = location.pathname === "/";

  return (
    <div className="App">
      {/* {isHome && <Navbar />} */}
      <SnackbarProvider
        maxSnack={3}
        autoHideDuration={3000}
        anchorOrigin={{ vertical: "top", horizontal: "right" }} // ✅ Position
      >
        <Routes>
          {/* Website Routes */}
          <Route path="/" element={<Home />} />
          <Route path="/about-us" element={<AboutUs />} />
          <Route path="/contact-us" element={<ContactUs />} />

          {/* <Route path="/user-enquiry" element={<UserEnquiry />} /> */}

          <Route path="/postproperty" element={<PostPropertyPage />} />
          <Route
            path="/PostPropertyPageForm"
            element={<PostPropertyPageForm />}
          />
          <Route path="/PropertyForm2" element={<PropertyForm2 />} />
          <Route path="/PropertyForm3" element={<PropertyForm3 />} />
          <Route
            path="/PropertyListingPage"
            element={<PropertyListingPage />}
          />
          <Route
            path="/Propertyinfo/:postpropertyId"
            element={<Propertyinfo />}
          />
          <Route path="/property-listing" element={<PropertyListingPage />} />
          <Route path="/membership" element={<Membership />} />
          <Route path="/addtocart" element={<AddToCart />} />
          <Route path="/view-properties" element={<ViewProperty />} />
          <Route path="/payment/callback" element={<PaymentCallback />} />

          {/* <Route path="/ImageUploadForm" element={<ImageUploadForm/>}/> */}
          {/* Dashboard Routes */}
          <Route path="/dashboard" element={<DashboardLayout />}>
            {/* <Route path="/dashboard/:encryptId" element={<DashboardLayout />}> */}
            <Route index element={<MyDashboard />} />
            <Route path="post-new-property" element={<PostNewProperty />} />
            <Route
              path="edit-property/:postpropertyId"
              element={<PostNewProperty />}
            />{" "}
            {/* ✅ relative path */}
            <Route path="publish-property" element={<PublishProperty />} />
            <Route
              path="publish-property/:postpropertyId"
              element={<PublishProperty />}
            />
            <Route path="manage-listings" element={<ManageListings />} />
            <Route path="buyer-enquiries" element={<BuyerEnquiries />} />
            <Route path="property-analytics" element={<PropertyAnalytics />} />
            <Route path="ads-management" element={<AdsManagement />} />
            <Route path="ads-form" element={<AdsForm />} />
            <Route path="ads-formupdate/:adsId" element={<AdsForm />} />
            <Route path="profile" element={<Profile />} />
            <Route path="edit-profile" element={<EditProfile />} />
          </Route>
          {/* </Route> */}
        </Routes>
      </SnackbarProvider>
    </div>
  );
}

export default App;
