import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {TransactionTypeMaster, TransactionTypeMasterRelations} from '../models';

export class TransactionTypeMasterRepository extends DefaultCrudRepository<
  TransactionTypeMaster,
  typeof TransactionTypeMaster.prototype.transactionId,
  TransactionTypeMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(TransactionTypeMaster, dataSource);
  }
}
