import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {TestimonialMaster, TestimonialMasterRelations} from '../models';

export class TestimonialMasterRepository extends DefaultCrudRepository<
  TestimonialMaster,
  typeof TestimonialMaster.prototype.testimonialId,
  TestimonialMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(TestimonialMaster, dataSource);
  }
}
