import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, CityMaster, Usertype} from '../models';
import {CityMasterRepository} from './city-master.repository';
import {UsertypeRepository} from './usertype.repository';

export class BuyerMasterRepository extends DefaultCrudRepository<
  BuyerMaster,
  typeof BuyerMaster.prototype.id
> {
  public readonly city: BelongsToAccessor<CityMaster, typeof BuyerMaster.prototype.id>;
  public readonly usertype: BelongsToAccessor<Usertype, typeof BuyerMaster.prototype.id>;

  constructor(
    @inject('datasources.db') dataSource: DblelloDataSource,
    @repository.getter('CityMasterRepository')
    protected cityMasterRepositoryGetter: Getter<CityMasterRepository>,
    @repository.getter('UsertypeRepository')

    protected usertypeRepositoryGetter: Getter<UsertypeRepository>,
  ) {
    super(BuyerMaster, dataSource);

    this.city = this.createBelongsToAccessorFor(
      'fkcityId',
      cityMasterRepositoryGetter,
    );
    this.registerInclusionResolver('fkcityId', this.city.inclusionResolver);

    this.usertype = this.createBelongsToAccessorFor(
      'fkusertypeId',
      usertypeRepositoryGetter,
    );
    this.registerInclusionResolver('fkusertypeId', this.usertype.inclusionResolver);
  }
}
