import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {RealEstateMaster, RealEstateMasterRelations} from '../models';

export class RealEstateMasterRepository extends DefaultCrudRepository<
  RealEstateMaster,
  typeof RealEstateMaster.prototype.blogId,
  RealEstateMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(RealEstateMaster, dataSource);
  }
}
