import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {PostTypeMaster, PostTypeMasterRelations} from '../models';

export class PostTypeMasterRepository extends DefaultCrudRepository<
  PostTypeMaster,
  typeof PostTypeMaster.prototype.postTypeId,
  PostTypeMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(PostTypeMaster, dataSource);
  }
}
