/* eslint-disable @typescript-eslint/no-unused-vars */
import {Getter, inject} from '@loopback/core';
import {
  BelongsToAccessor,
  DefaultCrudRepository,
  HasManyThroughRepositoryFactory,
  repository
} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';

import {
  AmenitiesMaster,
  AvailableStatusMaster,
  FacingMaster,
  FloorMaster,
  FurnishingtypeMaster,
  MainProperttyTypeMaster,
  MaintenanceMonthMaster,
  OtherRoomMaster,
  OwnershipMaster,
  PossessionMaster,
  PostPropertyAmenities,
  PostPropertyMaster,
  PostPropertyMasterRelations,
  PostTypeMaster,
  PropertyTypeMaster,
  PublishTypeMaster,
  SellerMaster,
  TransactionTypeMaster,
  Usertype
} from '../models';

import {AmenitiesMasterRepository} from './amenities-master.repository';
import {AvailableStatusMasterRepository} from './available-status-master.repository';
import {FacingMasterRepository} from './facing-master.repository';
import {FloorMasterRepository} from './floor-master.repository';
import {FurnishingtypeMasterRepository} from './furnishingtype-master.repository';
import {MainProperttyTypeMasterRepository} from './main-propertty-type-master.repository';
import {MaintenanceMonthMasterRepository} from './maintenance-month-master.repository';
import {OtherRoomMasterRepository} from './other-room-master.repository';
import {OwnershipMasterRepository} from './ownership-master.repository';
import {PossessionMasterRepository} from './possession-master.repository';
import {PostPropertyAmenitiesRepository} from './post-property-amenities.repository';
import {PostTypeMasterRepository} from './post-type-master.repository';
import {PropertyTypeMasterRepository} from './property-type-master.repository';
import {PublishTypeMasterRepository} from './publish-type-master.repository';
import {SellerMasterRepository} from './seller-master.repository';
import {TransactionTypeMasterRepository} from './transaction-type-master.repository';
import {UsertypeRepository} from './usertype.repository';

export class PostPropertyMasterRepository extends DefaultCrudRepository<
  PostPropertyMaster,
  typeof PostPropertyMaster.prototype.postpropertyId,
  PostPropertyMasterRelations
> {
  public readonly seller: BelongsToAccessor<
    SellerMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly publishType: BelongsToAccessor<
    PublishTypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly furnishingType: BelongsToAccessor<
    FurnishingtypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly possessionType: BelongsToAccessor<
    PossessionMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly transactionType: BelongsToAccessor<
    TransactionTypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly floor: BelongsToAccessor<
    FloorMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly mainPropertyType: BelongsToAccessor<
    MainProperttyTypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly maintenanceMonth: BelongsToAccessor<
    MaintenanceMonthMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly otherRoom: BelongsToAccessor<
    OtherRoomMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly ownership: BelongsToAccessor<
    OwnershipMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly userType: BelongsToAccessor<
    Usertype,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly postType: BelongsToAccessor<
    PostTypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly propertyType: BelongsToAccessor<
    PropertyTypeMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly availableStatus: BelongsToAccessor<
    AvailableStatusMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  public readonly facing: BelongsToAccessor<
    FacingMaster,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  // public readonly amenities: BelongsToAccessor<
  //   AmenitiesMaster,
  //   typeof PostPropertyMaster.prototype.postpropertyId
  // >;
  public readonly amenities: HasManyThroughRepositoryFactory<
    AmenitiesMaster,
    typeof AmenitiesMaster.prototype.amenitiesId,
    PostPropertyAmenities,
    typeof PostPropertyMaster.prototype.postpropertyId
  >;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,

    @repository.getter('SellerMasterRepository')
    protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>,

    @repository.getter('PublishTypeMasterRepository')
    protected publishTypeMasterRepositoryGetter: Getter<PublishTypeMasterRepository>,

    @repository.getter('FurnishingtypeMasterRepository')
    protected furnishingTypeMasterRepositoryGetter: Getter<FurnishingtypeMasterRepository>,

    @repository.getter('PossessionMasterRepository')
    protected possessionMasterRepositoryGetter: Getter<PossessionMasterRepository>,

    @repository.getter('TransactionTypeMasterRepository')
    protected transactionTypeMasterRepositoryGetter: Getter<TransactionTypeMasterRepository>,

    @repository.getter('FloorMasterRepository')
    protected floorMasterRepositoryGetter: Getter<FloorMasterRepository>,

    @repository.getter('MainProperttyTypeMasterRepository')
    protected mainPropertyTypeMasterRepositoryGetter: Getter<MainProperttyTypeMasterRepository>,

    @repository.getter('MaintenanceMonthMasterRepository')
    protected maintenanceMonthMasterRepositoryGetter: Getter<MaintenanceMonthMasterRepository>,

    @repository.getter('OtherRoomMasterRepository')
    protected otherRoomMasterRepositoryGetter: Getter<OtherRoomMasterRepository>,

    @repository.getter('OwnershipMasterRepository')
    protected ownershipMasterRepositoryGetter: Getter<OwnershipMasterRepository>,

    @repository.getter('UsertypeRepository')
    protected userTypeRepositoryGetter: Getter<UsertypeRepository>,

    @repository.getter('PostTypeMasterRepository')
    protected postTypeMasterRepositoryGetter: Getter<PostTypeMasterRepository>,

    @repository.getter('PropertyTypeMasterRepository')
    protected propertyTypeMasterRepositoryGetter: Getter<PropertyTypeMasterRepository>,

    @repository.getter('AvailableStatusMasterRepository')
    protected availableStatusMasterRepositoryGetter: Getter<AvailableStatusMasterRepository>,

    @repository.getter('FacingMasterRepository')
    protected facingMasterRepositoryGetter: Getter<FacingMasterRepository>,

    @repository.getter('AmenitiesMasterRepository')
    protected amenitiesRepositoryGetter: Getter<AmenitiesMasterRepository>,

    @repository.getter('PostPropertyAmenitiesRepository')
    protected propertyAmenitiesRepositoryGetter: Getter<PostPropertyAmenitiesRepository>,
  ) {
    super(PostPropertyMaster, dataSource);

    this.seller = this.createBelongsToAccessorFor(
      'seller',
      sellerMasterRepositoryGetter,
    );
    this.registerInclusionResolver('seller', this.seller.inclusionResolver);

    this.publishType = this.createBelongsToAccessorFor(
      'publishType',
      publishTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'publishType',
      this.publishType.inclusionResolver,
    );

    this.furnishingType = this.createBelongsToAccessorFor(
      'furnishingType',
      furnishingTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'furnishingType',
      this.furnishingType.inclusionResolver,
    );

    this.possessionType = this.createBelongsToAccessorFor(
      'possessionType',
      possessionMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'possessionType',
      this.possessionType.inclusionResolver,
    );

    this.transactionType = this.createBelongsToAccessorFor(
      'transactionType',
      transactionTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'transactionType',
      this.transactionType.inclusionResolver,
    );

    this.floor = this.createBelongsToAccessorFor('floor', floorMasterRepositoryGetter);
    this.registerInclusionResolver('floor', this.floor.inclusionResolver);

    this.mainPropertyType = this.createBelongsToAccessorFor(
      'mainPropertyType',
      mainPropertyTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'mainPropertyType',
      this.mainPropertyType.inclusionResolver,
    );

    this.maintenanceMonth = this.createBelongsToAccessorFor(
      'maintenanceMonth',
      maintenanceMonthMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'maintenanceMonth',
      this.maintenanceMonth.inclusionResolver,
    );

    this.otherRoom = this.createBelongsToAccessorFor(
      'otherRoom',
      otherRoomMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'otherRoom',
      this.otherRoom.inclusionResolver,
    );

    this.ownership = this.createBelongsToAccessorFor(
      'ownership',
      ownershipMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'ownership',
      this.ownership.inclusionResolver,
    );

    this.userType = this.createBelongsToAccessorFor(
      'userType',
      userTypeRepositoryGetter,
    );
    this.registerInclusionResolver(
      'userType',
      this.userType.inclusionResolver,
    );

    this.postType = this.createBelongsToAccessorFor(
      'postType',
      postTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver('postType', this.postType.inclusionResolver);

    this.propertyType = this.createBelongsToAccessorFor(
      'propertyType',
      propertyTypeMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'propertyType',
      this.propertyType.inclusionResolver,
    );

    this.availableStatus = this.createBelongsToAccessorFor(
      'availableStatus',
      availableStatusMasterRepositoryGetter,
    );
    this.registerInclusionResolver(
      'availableStatus',
      this.availableStatus.inclusionResolver,
    );

    this.facing = this.createBelongsToAccessorFor(
      'facing',
      facingMasterRepositoryGetter,
    );
    this.registerInclusionResolver('facing', this.facing.inclusionResolver);

    // this.amenities = this.createBelongsToAccessorFor(
    //   'amenities',
    //   amenitiesRepositoryGetter,
    // );
    // this.registerInclusionResolver('amenities', this.amenities.inclusionResolver);

    this.amenities = this.createHasManyThroughRepositoryFactoryFor(
      'amenities',
      amenitiesRepositoryGetter,
      propertyAmenitiesRepositoryGetter,
    );
    this.registerInclusionResolver('amenities', this.amenities.inclusionResolver);
  }
}
