import {Getter, inject} from '@loopback/core';
import {DefaultCrudRepository, BelongsToAccessor, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {AmenitiesMaster, PostPropertyAmenities, PostPropertyAmenitiesRelations, PostPropertyMaster} from '../models';
import { PostPropertyMasterRepository } from './post-property-master.repository';
import {AmenitiesMasterRepository} from './amenities-master.repository';

export class PostPropertyAmenitiesRepository extends DefaultCrudRepository<
  PostPropertyAmenities,
  typeof PostPropertyAmenities.prototype.id,
  PostPropertyAmenitiesRelations
> {
  public readonly postProperty: BelongsToAccessor<
  PostPropertyMaster,
  typeof PostPropertyAmenities.prototype.id
>;
public readonly amenity: BelongsToAccessor<
  AmenitiesMaster,
  typeof PostPropertyAmenities.prototype.id
>;
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
      @repository.getter('PostPropertyMasterRepository')
    protected postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>,
    @repository.getter('AmenitiesMasterRepository')
    protected amenitiesMasterRepositoryGetter: Getter<AmenitiesMasterRepository>,
  ) {
    super(PostPropertyAmenities, dataSource);

    this.postProperty = this.createBelongsToAccessorFor(
      'postProperty',
      postPropertyMasterRepositoryGetter,
    );
    this.registerInclusionResolver('postProperty', this.postProperty.inclusionResolver);
    this.amenity = this.createBelongsToAccessorFor(
      'amenity',
      amenitiesMasterRepositoryGetter,
    );
    this.registerInclusionResolver('amenity', this.amenity.inclusionResolver);
  }
}
