// src/repositories/package-purchase.repository.ts
import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {PackagePurchase, PackagePurchaseRelations} from '../models';
import {Getter} from '@loopback/core';
import {BelongsToAccessor, repository} from '@loopback/repository';
import {PackageMaster} from '../models';
import {PackageMasterRepository} from './package-master.repository';

export class PackagePurchaseRepository extends DefaultCrudRepository<
  PackagePurchase,
  typeof PackagePurchase.prototype.packagePurchaseId,
  PackagePurchaseRelations
> {
  public readonly package: BelongsToAccessor<PackageMaster, typeof PackagePurchase.prototype.packagePurchaseId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('PackageMasterRepository') protected packageMasterRepositoryGetter: Getter<PackageMasterRepository>,
  ) {
    super(PackagePurchase, dataSource);

    this.package = this.createBelongsToAccessorFor('package', packageMasterRepositoryGetter);
    this.registerInclusionResolver('package', this.package.inclusionResolver);
  }
}
