import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {OtpVerification, OtpVerificationRelations} from '../models';

export class OtpVerificationRepository extends DefaultCrudRepository<
  OtpVerification,
  typeof OtpVerification.prototype.otpId,
  OtpVerificationRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(OtpVerification, dataSource);
  }
}
